/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ISpriteRegistry;
import forestry.api.core.ITextureManager;
import forestry.core.errors.ErrorStateRegistry;
import forestry.core.render.ForestrySpriteUploader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureManagerForestry
implements ITextureManager {
    public static final ResourceLocation LOCATION_FORESTRY_TEXTURE = new ResourceLocation("forestry", "textures/atlas/gui.png");
    private static final TextureManagerForestry INSTANCE = new TextureManagerForestry();
    private final List<ISpriteRegister> spriteRegisters = new ArrayList<ISpriteRegister>();
    private ForestrySpriteUploader spriteUploader;

    public static TextureManagerForestry getInstance() {
        return INSTANCE;
    }

    private TextureManagerForestry() {
    }

    public void init(ForestrySpriteUploader spriteUploader) {
        ErrorStateRegistry.initSprites(spriteUploader);
        TextureManagerForestry.initDefaultSprites(spriteUploader);
        this.spriteUploader = spriteUploader;
    }

    @Nullable
    public ForestrySpriteUploader getSpriteUploader() {
        return this.spriteUploader;
    }

    private static void initDefaultSprites(ISpriteRegistry registry) {
        String[] defaultIconNames;
        for (String identifier : defaultIconNames = new String[]{"habitats/desert", "habitats/end", "habitats/forest", "habitats/hills", "habitats/jungle", "habitats/mushroom", "habitats/nether", "habitats/ocean", "habitats/plains", "habitats/snow", "habitats/swamp", "habitats/taiga", "misc/access.shared", "misc/energy", "misc/hint", "analyzer/anything", "analyzer/bee", "analyzer/cave", "analyzer/closed", "analyzer/drone", "analyzer/flyer", "analyzer/item", "analyzer/nocturnal", "analyzer/princess", "analyzer/pure_breed", "analyzer/pure_cave", "analyzer/pure_flyer", "analyzer/pure_nocturnal", "analyzer/queen", "analyzer/tree", "analyzer/sapling", "analyzer/pollen", "analyzer/flutter", "analyzer/butterfly", "analyzer/serum", "analyzer/caterpillar", "analyzer/cocoon", "errors/errored", "errors/unknown", "slots/blocked", "slots/blocked_2", "slots/liquid", "slots/container", "slots/locked", "slots/cocoon", "slots/bee", "mail/carrier.player", "mail/carrier.trader"}) {
            registry.addSprite(new ResourceLocation("forestry", identifier));
        }
    }

    @Override
    public TextureAtlasSprite getDefault(String identifier) {
        return this.spriteUploader.func_215282_a(new ResourceLocation("forestry", identifier));
    }

    @Override
    public ResourceLocation getGuiTextureMap() {
        return LOCATION_FORESTRY_TEXTURE;
    }

    public void bindGuiTextureMap() {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        ResourceLocation guiTextureMap = this.getGuiTextureMap();
        textureManager.func_110577_a(guiTextureMap);
    }

    public void registerBlock(Block block) {
        if (block instanceof ISpriteRegister) {
            this.spriteRegisters.add((ISpriteRegister)block);
        }
    }

    public void registerItem(Item item) {
        if (item instanceof ISpriteRegister) {
            this.spriteRegisters.add((ISpriteRegister)item);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerSprites(ISpriteRegistry registry) {
        for (ISpriteRegister spriteRegister : this.spriteRegisters) {
            spriteRegister.registerSprites(registry);
        }
    }

    static {
        ForestryAPI.textureManager = INSTANCE;
    }
}

