/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INbtWritable;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.EscritoireGameToken;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IKaryotype;
import genetics.api.root.IIndividualRoot;
import genetics.utils.RootUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class EscritoireGameBoard
implements INbtWritable,
IStreamable {
    private static final Random rand = new Random();
    private static final int TOKEN_COUNT_MAX = 22;
    private static final int TOKEN_COUNT_MIN = 6;
    private final List<EscritoireGameToken> gameTokens = new ArrayList<EscritoireGameToken>(22);
    private int tokenCount;

    public EscritoireGameBoard() {
    }

    public EscritoireGameBoard(CompoundNBT nbt) {
        this.tokenCount = nbt.func_74762_e("TokenCount");
        if (this.tokenCount > 0) {
            EscritoireGameToken[] tokens = new EscritoireGameToken[this.tokenCount];
            ListNBT nbttaglist = nbt.func_150295_c("GameTokens", 10);
            for (int j = 0; j < nbttaglist.size(); ++j) {
                CompoundNBT CompoundNBT2 = nbttaglist.func_150305_b(j);
                byte index = CompoundNBT2.func_74771_c("Slot");
                tokens[index] = new EscritoireGameToken(CompoundNBT2);
            }
            Collections.addAll(this.gameTokens, tokens);
        }
    }

    public boolean initialize(ItemStack specimen) {
        Optional<IIndividual> optional = RootUtils.getIndividual(specimen);
        if (!optional.isPresent()) {
            return false;
        }
        IIndividual individual = optional.get();
        IGenome genome = individual.getGenome();
        IKaryotype karyotype = genome.getKaryotype();
        IIndividualRoot<? extends IIndividual> root = genome.getPrimary().getRoot();
        this.tokenCount = EscritoireGameBoard.getTokenCount(genome);
        for (int i = 0; i < this.tokenCount / 2; ++i) {
            IAllele[] randomTemplate = root.getTemplates().getRandomTemplate(rand);
            String speciesUid = randomTemplate[karyotype.getSpeciesType().getIndex()].getRegistryName().toString();
            this.gameTokens.add(new EscritoireGameToken(speciesUid));
            this.gameTokens.add(new EscritoireGameToken(speciesUid));
        }
        Collections.shuffle(this.gameTokens);
        return true;
    }

    @Nullable
    public EscritoireGameToken getToken(int index) {
        if (index >= this.tokenCount) {
            return null;
        }
        return this.gameTokens.get(index);
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public void hideProbedTokens() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (!token.isProbed()) continue;
            token.setProbed(false);
        }
    }

    private List<EscritoireGameToken> getUnrevealedTokens() {
        ArrayList<EscritoireGameToken> unrevealed = new ArrayList<EscritoireGameToken>();
        for (EscritoireGameToken token : this.gameTokens) {
            if (token.isVisible()) continue;
            unrevealed.add(token);
        }
        return unrevealed;
    }

    @Nullable
    private EscritoireGameToken getSelected() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (!token.isSelected()) continue;
            return token;
        }
        return null;
    }

    private boolean isBoardCleared() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (token.isMatched()) continue;
            return false;
        }
        return true;
    }

    public void probe() {
        List<EscritoireGameToken> tokens = this.getUnrevealedTokens();
        int index = rand.nextInt(tokens.size());
        EscritoireGameToken token = tokens.get(index);
        token.setProbed(true);
    }

    public EscritoireGame.Status choose(EscritoireGameToken token) {
        EscritoireGame.Status status = EscritoireGame.Status.PLAYING;
        if (token.isMatched() || token.isSelected()) {
            return status;
        }
        EscritoireGameToken selected = this.getSelected();
        if (selected == null) {
            token.setSelected();
            this.hideProbedTokens();
        } else if (token.matches(selected)) {
            selected.setMatched();
            token.setMatched();
            if (this.isBoardCleared()) {
                status = EscritoireGame.Status.SUCCESS;
            }
            this.hideProbedTokens();
        } else {
            token.setFailed();
            selected.setFailed();
            status = EscritoireGame.Status.FAILURE;
        }
        return status;
    }

    public void reset() {
        this.gameTokens.clear();
        this.tokenCount = 0;
    }

    private static int getTokenCount(IGenome genome) {
        IAlleleForestrySpecies species1 = genome.getPrimary(IAlleleForestrySpecies.class);
        IAlleleForestrySpecies species2 = genome.getSecondary(IAlleleForestrySpecies.class);
        int tokenCount = species1.getComplexity() + species2.getComplexity();
        if (tokenCount % 2 != 0) {
            tokenCount = Math.round((float)tokenCount / 2.0f) * 2;
        }
        if (tokenCount > 22) {
            tokenCount = 22;
        } else if (tokenCount < 6) {
            tokenCount = 6;
        }
        return tokenCount;
    }

    @Override
    public CompoundNBT write(CompoundNBT compoundNBT) {
        if (this.tokenCount > 0) {
            compoundNBT.func_74768_a("TokenCount", this.tokenCount);
            ListNBT nbttaglist = new ListNBT();
            for (int i = 0; i < this.tokenCount; ++i) {
                EscritoireGameToken token = this.gameTokens.get(i);
                if (token == null) continue;
                CompoundNBT compoundNBT2 = new CompoundNBT();
                compoundNBT2.func_74774_a("Slot", (byte)i);
                token.write(compoundNBT2);
                nbttaglist.add((Object)compoundNBT2);
            }
            compoundNBT.func_218657_a("GameTokens", (INBT)nbttaglist);
        } else {
            compoundNBT.func_74768_a("TokenCount", 0);
        }
        return compoundNBT;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.func_150787_b(this.tokenCount);
        data.writeStreamables(this.gameTokens);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        this.tokenCount = data.func_150792_a();
        data.readStreamables(this.gameTokens, EscritoireGameToken::new);
    }
}

