/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INbtWritable;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.ColourUtil;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IIndividual;
import genetics.api.root.IIndividualRoot;
import genetics.utils.AlleleUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class EscritoireGameToken
implements INbtWritable,
IStreamable {
    private static final String[] OVERLAY_NONE = new String[0];
    private static final String[] OVERLAY_FAILED = new String[]{"errors/errored"};
    private static final String[] OVERLAY_SELECTED = new String[]{"errors/unknown"};
    @Nullable
    private IIndividual tokenIndividual;
    private ItemStack tokenStack = ItemStack.field_190927_a;
    private State state = State.UNREVEALED;

    public EscritoireGameToken(PacketBufferForestry data) {
        this.readData(data);
    }

    public EscritoireGameToken(String speciesUid) {
        this.setTokenSpecies(speciesUid);
    }

    public EscritoireGameToken(CompoundNBT CompoundNBT2) {
        if (CompoundNBT2.func_74764_b("state")) {
            int stateOrdinal = CompoundNBT2.func_74762_e("state");
            this.state = State.values()[stateOrdinal];
        }
        if (CompoundNBT2.func_74764_b("tokenSpecies")) {
            String speciesUid = CompoundNBT2.func_74779_i("tokenSpecies");
            this.setTokenSpecies(speciesUid);
        }
    }

    private void setTokenSpecies(String speciesUid) {
        Optional optionalAllele = AlleleUtils.getAllele(speciesUid);
        if (!optionalAllele.isPresent()) {
            return;
        }
        IAllele allele = (IAllele)optionalAllele.get();
        if (allele instanceof IAlleleForestrySpecies) {
            IAlleleForestrySpecies species = (IAlleleForestrySpecies)allele;
            IIndividualRoot<? extends IIndividual> root = species.getRoot();
            IAllele[] template = root.getTemplates().getTemplate(species.getRegistryName().toString());
            this.tokenIndividual = root.templateAsIndividual(template);
            this.tokenStack = root.getTypes().createStack(this.tokenIndividual, ((IForestrySpeciesRoot)root).getIconType());
        }
    }

    public ItemStack getTokenStack() {
        return this.tokenStack;
    }

    public boolean isVisible() {
        return this.state != State.UNREVEALED;
    }

    public boolean isProbed() {
        return this.state == State.PROBED;
    }

    public boolean isMatched() {
        return this.state == State.MATCHED;
    }

    public boolean isSelected() {
        return this.state == State.SELECTED;
    }

    public void setFailed() {
        this.state = State.FAILED;
    }

    public void setProbed(boolean probed) {
        this.state = probed ? State.PROBED : State.UNREVEALED;
    }

    public void setSelected() {
        this.state = State.SELECTED;
    }

    public void setMatched() {
        this.state = State.MATCHED;
    }

    public int getTokenColour() {
        if (this.tokenIndividual == null || !this.isVisible()) {
            return 0xFFFFFF;
        }
        int iconColor = this.tokenIndividual.getGenome().getPrimary(IAlleleForestrySpecies.class).getSpriteColour(0);
        if (this.state == State.MATCHED) {
            return ColourUtil.multiplyRGBComponents(iconColor, 0.7f);
        }
        return iconColor;
    }

    public ITextComponent getTooltip() {
        return !this.tokenStack.func_190926_b() ? this.tokenStack.func_200301_q() : new TranslationTextComponent("for.gui.unknown");
    }

    public String[] getOverlayIcons() {
        switch (this.state) {
            case FAILED: {
                return OVERLAY_FAILED;
            }
            case SELECTED: {
                return OVERLAY_SELECTED;
            }
        }
        return OVERLAY_NONE;
    }

    public boolean matches(EscritoireGameToken other) {
        return ItemStack.func_77989_b((ItemStack)this.tokenStack, (ItemStack)other.getTokenStack());
    }

    @Override
    public CompoundNBT write(CompoundNBT CompoundNBT2) {
        CompoundNBT2.func_74768_a("state", this.state.ordinal());
        if (this.tokenIndividual != null) {
            CompoundNBT2.func_74778_a("tokenSpecies", this.tokenIndividual.getGenome().getPrimary().getRegistryName().toString());
        }
        return CompoundNBT2;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeEnum(this.state, State.VALUES);
        if (this.tokenIndividual != null) {
            data.writeBoolean(true);
            data.func_180714_a(this.tokenIndividual.getGenome().getPrimary().getRegistryName().toString());
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public void readData(PacketBufferForestry data) {
        this.state = (State)data.readEnum(State.VALUES);
        if (data.readBoolean()) {
            String speciesUid = data.func_218666_n();
            this.setTokenSpecies(speciesUid);
        }
    }

    private static enum State {
        UNREVEALED,
        PROBED,
        SELECTED,
        MATCHED,
        FAILED;

        public static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

