/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.arboriculture.TreeManager;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.features.CoreTiles;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.ForestryFluids;
import forestry.core.fluids.TankManager;
import forestry.core.gui.ContainerAnalyzer;
import forestry.core.inventory.InventoryAnalyzer;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;
import forestry.modules.ModuleHelper;
import genetics.api.GeneticHelper;
import genetics.api.individual.IIndividual;
import genetics.utils.RootUtils;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileAnalyzer
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IItemStackDisplay {
    private static final int TIME_TO_ANALYZE = 125;
    private static final int HONEY_REQUIRED = 100;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final IInventory invInput;
    private final IInventory invOutput;
    @Nullable
    private IIndividual specimenToAnalyze;
    private ItemStack individualOnDisplayClient = ItemStack.field_190927_a;

    public TileAnalyzer() {
        super(CoreTiles.ANALYZER.tileType(), 800, 5000);
        this.setInternalInventory(new InventoryAnalyzer(this));
        this.resourceTank = new FilteredTank(10000).setFilters(ForestryFluids.HONEY.getFluid());
        this.tankManager = new TankManager(this, this.resourceTank);
        this.invInput = new InventoryMapper((IInventory)this.getInternalInventory(), 2, 6);
        this.invOutput = new InventoryMapper((IInventory)this.getInternalInventory(), 8, 4);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.tankManager.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.tankManager.read(compoundNBT);
        ItemStack stackToAnalyze = this.func_70301_a(0);
        if (!stackToAnalyze.func_190926_b()) {
            this.specimenToAnalyze = RootUtils.getIndividualOrNull(stackToAnalyze);
        }
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 1);
        }
    }

    @Override
    public boolean workCycle() {
        boolean added;
        ItemStack stackToAnalyze = this.func_70301_a(0);
        if (stackToAnalyze.func_190926_b() || this.specimenToAnalyze == null) {
            return false;
        }
        if (!this.specimenToAnalyze.isAnalyzed()) {
            FluidStack drained = this.resourceTank.drain(100, IFluidHandler.FluidAction.SIMULATE);
            if (drained.isEmpty() || drained.getAmount() != 100) {
                return false;
            }
            this.resourceTank.drain(100, IFluidHandler.FluidAction.EXECUTE);
            this.specimenToAnalyze.analyze();
            GeneticHelper.setIndividual(stackToAnalyze, this.specimenToAnalyze);
        }
        if (!(added = InventoryUtil.tryAddStack(this.invOutput, stackToAnalyze, true))) {
            return false;
        }
        this.func_70299_a(0, ItemStack.field_190927_a);
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        NetworkUtil.sendNetworkPacket(packet, this.field_174879_c, this.field_145850_b);
        return true;
    }

    @Nullable
    private Integer getInputSlotIndex() {
        for (int slotIndex = 0; slotIndex < this.invInput.func_70302_i_(); ++slotIndex) {
            ItemStack inputStack = this.invInput.func_70301_a(slotIndex);
            if (!RootUtils.isIndividual(inputStack)) continue;
            return slotIndex;
        }
        return null;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        ItemStack displayStack = this.getIndividualOnDisplay();
        data.func_150788_a(displayStack);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.individualOnDisplayClient = data.func_150791_c();
        this.tankManager.readData(data);
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)this.individualOnDisplayClient)) {
            this.individualOnDisplayClient = itemStack;
            BlockPos pos = this.func_174877_v();
            Minecraft.func_71410_x().field_71438_f.func_215328_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @Override
    public boolean hasWork() {
        this.moveSpecimenToAnalyzeSlot();
        ItemStack specimen = this.func_70301_a(0);
        boolean hasSpecimen = !specimen.func_190926_b();
        boolean hasResource = true;
        boolean hasSpace = true;
        if (hasSpecimen) {
            hasSpace = InventoryUtil.tryAddStack(this.invOutput, specimen, true, false);
            if (this.specimenToAnalyze != null && !this.specimenToAnalyze.isAnalyzed()) {
                FluidStack drained = this.resourceTank.drain(100, IFluidHandler.FluidAction.SIMULATE);
                hasResource = !drained.isEmpty() && drained.getAmount() == 100;
            }
        }
        this.getErrorLogic().setCondition(!hasSpecimen, EnumErrorCode.NO_SPECIMEN);
        this.getErrorLogic().setCondition(!hasResource, EnumErrorCode.NO_RESOURCE_LIQUID);
        this.getErrorLogic().setCondition(!hasSpace, EnumErrorCode.NO_SPACE_INVENTORY);
        return hasSpecimen && hasResource && hasSpace;
    }

    private void moveSpecimenToAnalyzeSlot() {
        if (!this.func_70301_a(0).func_190926_b()) {
            return;
        }
        Integer slotIndex = this.getInputSlotIndex();
        if (slotIndex == null) {
            return;
        }
        ItemStack inputStack = this.invInput.func_70301_a(slotIndex.intValue());
        if (inputStack.func_190926_b()) {
            return;
        }
        if (ModuleHelper.isEnabled("arboriculture") && !TreeManager.treeRoot.isMember(inputStack)) {
            inputStack = GeneticsUtil.convertToGeneticEquivalent(inputStack);
        }
        this.specimenToAnalyze = RootUtils.getIndividualOrNull(inputStack);
        if (this.specimenToAnalyze == null) {
            return;
        }
        this.func_70299_a(0, inputStack);
        this.invInput.func_70299_a(slotIndex.intValue(), ItemStack.field_190927_a);
        if (this.specimenToAnalyze.isAnalyzed()) {
            this.setTicksPerWorkCycle(1);
            this.setEnergyPerWorkCycle(0);
        } else {
            this.setTicksPerWorkCycle(125);
            this.setEnergyPerWorkCycle(Config.analyzerEnergyPerWork);
        }
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        NetworkUtil.sendNetworkPacket(packet, this.field_174879_c, this.field_145850_b);
    }

    public ItemStack getIndividualOnDisplay() {
        if (this.field_145850_b.field_72995_K) {
            return this.individualOnDisplayClient;
        }
        return this.func_70301_a(0);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerAnalyzer(windowId, player.field_71071_by, this);
    }
}

