/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.ForestryComponentKeys;
import forestry.api.genetics.IResearchHandler;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.core.features.CoreTiles;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.inventory.InventoryEscritoire;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;
import genetics.api.individual.IIndividual;
import genetics.api.root.IIndividualRoot;
import genetics.utils.RootUtils;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEscritoire
extends TileBase
implements ISidedInventory,
ISlotPickupWatcher,
IStreamableGui,
IItemStackDisplay {
    private final EscritoireGame game = new EscritoireGame();
    private ItemStack individualOnDisplayClient = ItemStack.field_190927_a;

    public TileEscritoire() {
        super(CoreTiles.ESCRITOIRE.tileType());
        this.setInternalInventory(new InventoryEscritoire(this));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.game.read(compoundNBT);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.game.write(compoundNBT);
        return compoundNBT;
    }

    public EscritoireGame getGame() {
        return this.game;
    }

    public void choose(GameProfile gameProfile, int index) {
        this.game.choose(index);
        this.processTurnResult(gameProfile);
    }

    private void processTurnResult(GameProfile gameProfile) {
        if (this.getGame().getStatus() != EscritoireGame.Status.SUCCESS) {
            return;
        }
        Optional<IIndividual> optional = RootUtils.getIndividual(this.func_70301_a(0));
        if (!optional.isPresent()) {
            return;
        }
        IIndividual individual = optional.get();
        IAlleleForestrySpecies species = individual.getGenome().getPrimary(IAlleleForestrySpecies.class);
        IIndividualRoot<? extends IIndividual> root = species.getRoot();
        IResearchHandler handler = (IResearchHandler)root.getComponent(ForestryComponentKeys.RESEARCH);
        for (ItemStack itemstack : handler.getResearchBounty(species, this.field_145850_b, gameProfile, individual, this.game.getBountyLevel())) {
            InventoryUtil.addStack((IInventory)this.getInternalInventory(), itemstack, 1, 6, true);
        }
    }

    private boolean areProbeSlotsFilled() {
        int filledSlots = 0;
        int required = this.game.getSampleSize(5);
        for (int i = 7; i < 7 + required; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ++filledSlots;
        }
        return filledSlots >= required;
    }

    public void probe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack analyze = this.func_70301_a(0);
        if (!analyze.func_190926_b() && this.areProbeSlotsFilled()) {
            this.game.probe(analyze, (IInventory)this, 7, 5);
        }
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.game.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.game.readData(data);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        ItemStack displayStack = this.getIndividualOnDisplay();
        data.func_150788_a(displayStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.individualOnDisplayClient = data.func_150791_c();
    }

    @Override
    public void onTake(int slotIndex, PlayerEntity player) {
        if (slotIndex == 0) {
            this.game.reset();
            PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
            NetworkUtil.sendNetworkPacket(packet, this.field_174879_c, this.field_145850_b);
        }
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        super.func_70299_a(slotIndex, itemstack);
        if (slotIndex == 0) {
            PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
            NetworkUtil.sendNetworkPacket(packet, this.field_174879_c, this.field_145850_b);
        }
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerEscritoire(windowId, player, this);
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)this.individualOnDisplayClient)) {
            this.individualOnDisplayClient = itemStack;
            Minecraft.func_71410_x().field_71438_f.func_215328_b(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        }
    }

    public ItemStack getIndividualOnDisplay() {
        if (this.field_145850_b.field_72995_K) {
            return this.individualOnDisplayClient;
        }
        return this.func_70301_a(0);
    }
}

