/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.google.common.base.Preconditions;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.ILocatable;
import forestry.core.errors.ErrorLogic;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.ITitled;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.TickHelper;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileForestry
extends TileEntity
implements IStreamable,
IErrorLogicSource,
ISidedInventory,
IFilterSlotDelegate,
ITitled,
ILocatable,
ITickableTileEntity,
INamedContainerProvider {
    private final ErrorLogic errorHandler = new ErrorLogic();
    private final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    private IInventoryAdapter inventory = FakeInventoryAdapter.instance();
    private final TickHelper tickHelper = new TickHelper();
    private boolean needsNetworkUpdate = false;

    public TileForestry(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    protected AdjacentTileCache getTileCache() {
        return this.tileCache;
    }

    public void onNeighborTileChange(World world, BlockPos pos, BlockPos neighbor) {
        this.tileCache.onNeighborChange();
    }

    public void func_145843_s() {
        this.tileCache.purge();
        super.func_145843_s();
    }

    public void func_145829_t() {
        this.tileCache.purge();
        super.func_145829_t();
    }

    public final void func_73660_a() {
        this.tickHelper.onTick();
        if (!this.field_145850_b.field_72995_K) {
            this.updateServerSide();
        } else {
            this.updateClientSide();
        }
        if (this.needsNetworkUpdate) {
            this.needsNetworkUpdate = false;
            this.sendNetworkUpdate();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientSide() {
    }

    protected void updateServerSide() {
    }

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickHelper.updateOnInterval(tickInterval);
    }

    public void func_230337_a_(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
        this.inventory.read(data);
    }

    public CompoundNBT func_189515_b(CompoundNBT data) {
        data = super.func_189515_b(data);
        this.inventory.write(data);
        return data;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }

    protected final void sendNetworkUpdate() {
        PacketTileStream packet = new PacketTileStream(this);
        NetworkUtil.sendNetworkPacket(packet, this.field_174879_c, this.field_145850_b);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
    }

    public void onRemoval() {
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    protected boolean isRedstoneActivated() {
        return this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    protected final void setNeedsNetworkUpdate() {
        this.needsNetworkUpdate = true;
    }

    @Override
    public final IErrorLogic getErrorLogic() {
        return this.errorHandler;
    }

    @Override
    public String getUnlocalizedTitle() {
        return this.func_195044_w().func_177230_c().func_149739_a();
    }

    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    protected final void setInternalInventory(IInventoryAdapter inv) {
        Preconditions.checkNotNull((Object)inv);
        this.inventory = inv;
    }

    public boolean func_191420_l() {
        return this.getInternalInventory().func_191420_l();
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_174889_b(PlayerEntity player) {
        this.getInternalInventory().func_174889_b(player);
    }

    public final void func_174886_c(PlayerEntity player) {
        this.getInternalInventory().func_174886_c(player);
    }

    public final boolean func_70300_a(PlayerEntity player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public int[] func_180463_a(Direction side) {
        return this.getInternalInventory().func_180463_a(side);
    }

    public final boolean func_180462_a(int slotIndex, ItemStack itemStack, Direction side) {
        return this.getInternalInventory().func_180462_a(slotIndex, itemStack, side);
    }

    public final boolean func_180461_b(int slotIndex, ItemStack itemStack, Direction side) {
        return this.getInternalInventory().func_180461_b(slotIndex, itemStack, side);
    }

    @Override
    public final BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    public void func_174888_l() {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this.getInternalInventory(), facing)).cast();
            }
            return LazyOptional.of(() -> new InvWrapper((IInventory)this.getInternalInventory())).cast();
        }
        return super.getCapability(capability, facing);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getUnlocalizedTitle());
    }
}

