/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Region;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileUtil {
    public static boolean isUsableByPlayer(PlayerEntity player, TileEntity tile) {
        BlockPos pos = tile.func_174877_v();
        World world = tile.func_145831_w();
        return !tile.func_145837_r() && TileUtil.getTile((IBlockReader)world, pos) == tile && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nullable
    public static TileEntity getTile(IBlockReader world, BlockPos pos) {
        if (world instanceof Region) {
            Region chunkCache = (Region)world;
            return chunkCache.func_175625_s(pos);
        }
        return world.func_175625_s(pos);
    }

    @Nullable
    public static <T> T getTile(IBlockReader world, BlockPos pos, Class<T> tileClass) {
        TileEntity tileEntity = TileUtil.getTile(world, pos);
        if (tileClass.isInstance(tileEntity)) {
            return tileClass.cast(tileEntity);
        }
        return null;
    }

    @Nullable
    public static <T> T getTile(LootContext.Builder builder, Class<T> tileClass) {
        TileEntity tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileClass.isInstance(tileEntity)) {
            return tileClass.cast(tileEntity);
        }
        return null;
    }

    @Nullable
    public static <T> T getTile(TileEntity tileEntity, Class<T> tileClass) {
        if (tileClass.isInstance(tileEntity)) {
            return tileClass.cast(tileEntity);
        }
        return null;
    }

    @Nullable
    public static <T, R> R getResultFromTile(IWorldReader world, BlockPos pos, Class<T> tileClass, ITileGetResult<T, R> tileGetResult) {
        T tile = TileUtil.getTile((IBlockReader)world, pos, tileClass);
        if (tile != null) {
            return tileGetResult.getResult(tile);
        }
        return null;
    }

    @Nullable
    public static <T, R> R getResultFromTile(TileEntity tileEntity, Class<T> tileClass, ITileGetResult<T, R> tileGetResult) {
        T tile = TileUtil.getTile(tileEntity, tileClass);
        if (tile != null) {
            return tileGetResult.getResult(tile);
        }
        return null;
    }

    public static <T> void actOnTile(IWorldReader world, BlockPos pos, Class<T> tileClass, ITileAction<T> tileAction) {
        T tile = TileUtil.getTile((IBlockReader)world, pos, tileClass);
        if (tile != null) {
            tileAction.actOnTile(tile);
        }
    }

    @Nullable
    public static IItemHandler getInventoryFromTile(@Nullable TileEntity tile, @Nullable Direction side) {
        if (tile == null) {
            return null;
        }
        LazyOptional itemCap = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (itemCap.isPresent()) {
            return (IItemHandler)itemCap.orElse(null);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    public static <T> LazyOptional<T> getInterface(World world, BlockPos pos, Capability<T> capability, @Nullable Direction facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return LazyOptional.empty();
        }
        return tileEntity.getCapability(capability, facing);
    }

    @FunctionalInterface
    public static interface ITileAction<T> {
        public void actOnTile(T var1);
    }

    public static interface ITileGetResult<T, R> {
        @Nullable
        public R getResult(T var1);
    }
}

