/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.WorldUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntityUtil {
    @Nullable
    public static <T extends MobEntity> T spawnEntity(World world, EntityType<T> type, double x, double y, double z) {
        T entityLiving = EntityUtil.createEntity(world, type);
        if (entityLiving == null) {
            return null;
        }
        return EntityUtil.spawnEntity(world, entityLiving, x, y, z);
    }

    public static <T extends MobEntity> T spawnEntity(World world, T living, double x, double y, double z) {
        living.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        living.field_70759_as = living.field_70177_z;
        living.field_70761_aq = living.field_70177_z;
        DifficultyInstance diff = world.func_175649_E(new BlockPos(x, y, z));
        living.func_213386_a((IServerWorld)WorldUtils.asServer((IWorld)world), diff, SpawnReason.MOB_SUMMONED, null, null);
        world.func_217376_c(living);
        living.func_70642_aH();
        return living;
    }

    @Nullable
    private static <T extends MobEntity> T createEntity(World world, EntityType<T> type) {
        ResourceLocation name = ForgeRegistries.ENTITIES.getKey(type);
        if (name == null) {
            return null;
        }
        return (T)((MobEntity)type.func_200721_a(world));
    }
}

