/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.circuits.ISocketable;
import forestry.core.inventory.ItemHandlerInventoryManipulator;
import forestry.core.inventory.StandardStackFilters;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.utils.ItemStackUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;

public abstract class InventoryUtil {
    public static boolean moveItemStack(IItemHandler source, IItemHandler dest) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(source);
        return manipulator.transferOneStack(dest, StandardStackFilters.ALL);
    }

    public static boolean moveItemStack(IItemHandler source, Iterable<IItemHandler> destinations) {
        for (IItemHandler dest : destinations) {
            if (!InventoryUtil.moveItemStack(source, dest)) continue;
            return true;
        }
        return false;
    }

    public static boolean moveOneItemToPipe(IItemHandler source, AdjacentTileCache tileCache) {
        return InventoryUtil.moveOneItemToPipe(source, tileCache, Direction.values());
    }

    public static boolean moveOneItemToPipe(IItemHandler source, AdjacentTileCache tileCache, Direction[] directions) {
        return false;
    }

    private static boolean internal_moveOneItemToPipe(IItemHandler source, AdjacentTileCache tileCache, Direction[] directions) {
        return false;
    }

    public static boolean consumeIngredients(IInventory inventory, NonNullList<Ingredient> ingredients, @Nullable PlayerEntity player, boolean stowContainer, boolean craftingTools, boolean doRemove) {
        int[] consumeStacks = ItemStackUtil.createConsume(ingredients, inventory, craftingTools);
        if (doRemove && consumeStacks.length > 0) {
            return InventoryUtil.consumeItems(inventory, consumeStacks, player, stowContainer);
        }
        return consumeStacks.length > 0;
    }

    private static boolean consumeItems(IInventory inventory, int[] consumeStacks, @Nullable PlayerEntity player, boolean stowContainer) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int count = consumeStacks[i];
            if (count <= 0) continue;
            ItemStack oldStack = inventory.func_70301_a(i);
            ItemStack removed = inventory.func_70298_a(i, count);
            if (stowContainer && oldStack.func_77973_b().hasContainerItem(oldStack)) {
                InventoryUtil.stowContainerItem(removed, inventory, i, player);
            }
            if (count <= removed.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    public static boolean removeSets(IInventory inventory, int count, NonNullList<ItemStack> set, @Nullable PlayerEntity player, boolean stowContainer, boolean craftingTools, boolean doRemove) {
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory);
        if (doRemove) {
            NonNullList<ItemStack> removed = InventoryUtil.removeSets(inventory, count, set, player, stowContainer, craftingTools);
            return removed != null && removed.size() >= count;
        }
        return ItemStackUtil.containsSets(set, stock, craftingTools) >= count;
    }

    @Nullable
    public static NonNullList<ItemStack> removeSets(IInventory inventory, int count, NonNullList<ItemStack> set, @Nullable PlayerEntity player, boolean stowContainer, boolean craftingTools) {
        NonNullList removed = NonNullList.func_191197_a((int)set.size(), (Object)ItemStack.field_190927_a);
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory);
        if (ItemStackUtil.containsSets(set, stock, craftingTools) < count) {
            return null;
        }
        for (int i = 0; i < set.size(); ++i) {
            ItemStack itemStack = (ItemStack)set.get(i);
            if (itemStack.func_190926_b()) continue;
            ItemStack stackToRemove = itemStack.func_77946_l();
            stackToRemove.func_190920_e(stackToRemove.func_190916_E() * count);
            ItemStack removedStack = InventoryUtil.removeStack(inventory, stackToRemove, player, stowContainer, false);
            if (removedStack.func_190926_b()) {
                removedStack = InventoryUtil.removeStack(inventory, stackToRemove, player, stowContainer, craftingTools);
            }
            removed.set(i, (Object)removedStack);
        }
        return removed;
    }

    private static ItemStack removeStack(IInventory inventory, ItemStack stackToRemove, @Nullable PlayerEntity player, boolean stowContainer, boolean craftingTools) {
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack stackInSlot = inventory.func_70301_a(j);
            if (stackInSlot.func_190926_b() || !ItemStackUtil.isCraftingEquivalent(stackToRemove, stackInSlot, craftingTools)) continue;
            ItemStack removed = inventory.func_70298_a(j, stackToRemove.func_190916_E());
            stackToRemove.func_190918_g(removed.func_190916_E());
            if (stowContainer && stackToRemove.func_77973_b().hasContainerItem(stackToRemove)) {
                InventoryUtil.stowContainerItem(removed, inventory, j, player);
            }
            if (!stackToRemove.func_190926_b()) continue;
            return removed;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean contains(IInventory inventory, NonNullList<ItemStack> query) {
        return InventoryUtil.contains(inventory, query, 0, inventory.func_70302_i_());
    }

    public static boolean contains(IInventory inventory, NonNullList<ItemStack> query, int startSlot, int slots) {
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory, startSlot, slots);
        return ItemStackUtil.containsSets(query, stock) > 0;
    }

    public static boolean isEmpty(IInventory inventory, int slotStart, int slotCount) {
        for (int i = slotStart; i < slotStart + slotCount; ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static NonNullList<ItemStack> getStacks(IInventory inventory) {
        NonNullList stacks = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stacks.set(i, (Object)inventory.func_70301_a(i));
        }
        return stacks;
    }

    public static NonNullList<ItemStack> getStacks(IInventory inventory, int slot1, int length) {
        NonNullList result = NonNullList.func_191197_a((int)length, (Object)ItemStack.field_190927_a);
        for (int i = slot1; i < slot1 + length; ++i) {
            result.set(i - slot1, (Object)inventory.func_70301_a(i));
        }
        return result;
    }

    public static boolean tryAddStacksCopy(IInventory inventory, NonNullList<ItemStack> stacks, int startSlot, int slots, boolean all) {
        for (ItemStack stack : stacks) {
            if (stack == null || stack.func_190926_b() || InventoryUtil.tryAddStack(inventory, stack.func_77946_l(), startSlot, slots, all)) continue;
            return false;
        }
        return true;
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all) {
        return InventoryUtil.tryAddStack(inventory, stack, 0, inventory.func_70302_i_(), all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all, boolean doAdd) {
        return InventoryUtil.tryAddStack(inventory, stack, 0, inventory.func_70302_i_(), all, doAdd);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all) {
        return InventoryUtil.tryAddStack(inventory, stack, startSlot, slots, all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all, boolean doAdd) {
        boolean success;
        int added = InventoryUtil.addStack(inventory, stack, startSlot, slots, false);
        boolean bl = all ? added == stack.func_190916_E() : (success = added > 0);
        if (success && doAdd) {
            InventoryUtil.addStack(inventory, stack, startSlot, slots, true);
        }
        return success;
    }

    public static int addStack(IInventory inventory, ItemStack stack, boolean doAdd) {
        return InventoryUtil.addStack(inventory, stack, 0, inventory.func_70302_i_(), doAdd);
    }

    public static int addStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean doAdd) {
        int i;
        if (stack.func_190926_b()) {
            return 0;
        }
        int added = 0;
        for (i = startSlot; i < startSlot + slots; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack.func_190926_b() || !inventoryStack.func_77985_e() || !inventoryStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.func_190916_E() - added;
            int space = inventoryStack.func_77976_d() - inventoryStack.func_190916_E();
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.func_190917_f(remain);
                }
                return stack.func_190916_E();
            }
            if (doAdd) {
                inventoryStack.func_190920_e(inventoryStack.func_77976_d());
            }
            added += space;
        }
        if (added >= stack.func_190916_E()) {
            return added;
        }
        for (i = startSlot; i < startSlot + slots; ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            if (doAdd) {
                inventory.func_70299_a(i, stack.func_77946_l());
                inventory.func_70301_a(i).func_190920_e(stack.func_190916_E() - added);
            }
            return stack.func_190916_E();
        }
        return added;
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd) {
        return InventoryUtil.stowInInventory(itemstack, inventory, doAdd, 0, inventory.func_70302_i_());
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack.func_190926_b()) {
                if (doAdd) {
                    inventory.func_70299_a(i, itemstack.func_77946_l());
                    itemstack.func_190920_e(0);
                }
                return true;
            }
            if (inventoryStack.func_190916_E() >= inventoryStack.func_77976_d() || !inventoryStack.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.func_77976_d() - inventoryStack.func_190916_E();
            if (space > itemstack.func_190916_E()) {
                if (doAdd) {
                    inventoryStack.func_190917_f(itemstack.func_190916_E());
                    itemstack.func_190920_e(0);
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.func_190920_e(inventoryStack.func_77976_d());
                itemstack.func_190918_g(space);
            }
            added = true;
        }
        return added;
    }

    public static void stowContainerItem(ItemStack itemstack, IInventory stowing, int slotIndex, @Nullable PlayerEntity player) {
        if (!itemstack.func_77973_b().hasContainerItem(itemstack)) {
            return;
        }
        ItemStack container = ForgeHooks.getContainerItem((ItemStack)itemstack);
        if (!(container.func_190926_b() || InventoryUtil.tryAddStack(stowing, container, slotIndex, 1, true) || InventoryUtil.tryAddStack(stowing, container, true) || player == null)) {
            player.func_71019_a(container, true);
        }
    }

    public static void deepCopyInventoryContents(IInventory source, IInventory destination) {
        if (source.func_70302_i_() != destination.func_70302_i_()) {
            throw new IllegalArgumentException("Inventory sizes do not match. Source: " + source + ", Destination: " + destination);
        }
        for (int i = 0; i < source.func_70302_i_(); ++i) {
            ItemStack stack = source.func_70301_a(i);
            if (!stack.func_190926_b()) {
                stack = stack.func_77946_l();
            }
            destination.func_70299_a(i, stack);
        }
    }

    public static void dropSockets(ISocketable socketable, World world, double x, double y, double z) {
        for (int slot = 0; slot < socketable.getSocketCount(); ++slot) {
            ItemStack itemstack = socketable.getSocket(slot);
            InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)itemstack);
            socketable.setSocket(slot, ItemStack.field_190927_a);
        }
    }

    public static void dropSockets(ISocketable socketable, World world, BlockPos pos) {
        InventoryUtil.dropSockets(socketable, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void readFromNBT(IInventory inventory, String name, CompoundNBT compoundNBT) {
        if (!compoundNBT.func_74764_b(name)) {
            return;
        }
        ListNBT nbttaglist = compoundNBT.func_150295_c(name, 10);
        for (int j = 0; j < nbttaglist.size(); ++j) {
            CompoundNBT compoundNBT2 = nbttaglist.func_150305_b(j);
            int index = compoundNBT2.func_74762_e("Slot");
            inventory.func_70299_a(index, ItemStack.func_199557_a((CompoundNBT)compoundNBT2));
        }
    }

    public static void writeToNBT(IInventory inventory, String name, CompoundNBT compoundNBT) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT compoundNBT2 = new CompoundNBT();
            compoundNBT2.func_74768_a("Slot", i);
            inventory.func_70301_a(i).func_77955_b(compoundNBT2);
            nbttaglist.add((Object)compoundNBT2);
        }
        compoundNBT.func_218657_a(name, (INBT)nbttaglist);
    }
}

