/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.tooltips.ToolTip;
import forestry.core.utils.Translator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTooltipUtil {
    @OnlyIn(value=Dist.CLIENT)
    public static void addInformation(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        String unlocalizedName = stack.func_77977_a();
        String tooltipKey = unlocalizedName + ".tooltip";
        if (Translator.canTranslateToLocal(tooltipKey)) {
            TranslationTextComponent tooltipInfo = new TranslationTextComponent(tooltipKey);
            tooltip.add((ITextComponent)tooltipInfo.func_240699_a_(TextFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addShiftInformation(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("for.gui.tooltip.tmi", new Object[]{"< %s >"}).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ToolTip getInformation(ItemStack stack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean advancedTooltips = minecraft.field_71474_y.field_82882_x;
        return ItemTooltipUtil.getInformation(stack, (PlayerEntity)minecraft.field_71439_g, (ITooltipFlag)(advancedTooltips ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ToolTip getInformation(ItemStack stack, PlayerEntity player, ITooltipFlag flag) {
        if (stack.func_190926_b()) {
            return null;
        }
        List tooltip = stack.func_82840_a(player, flag);
        for (int i = 0; i < tooltip.size(); ++i) {
            ITextComponent component = (ITextComponent)tooltip.get(i);
            if (i == 0) {
                tooltip.set(i, ((IFormattableTextComponent)component).func_240699_a_(stack.func_77953_t().field_77937_e));
                continue;
            }
            tooltip.set(i, ((IFormattableTextComponent)component).func_240699_a_(TextFormatting.GRAY));
        }
        ToolTip toolTip = new ToolTip();
        toolTip.addAll(tooltip);
        return toolTip;
    }
}

