/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;

public abstract class ModUtil {
    public static boolean isModLoaded(String modname) {
        return ModList.get().isLoaded(modname);
    }

    public static boolean isModLoaded(String modname, @Nullable String versionRangeString) {
        Optional cont;
        if (!ModUtil.isModLoaded(modname)) {
            return false;
        }
        if (versionRangeString != null && (cont = ModList.get().getModContainerById(modname)).isPresent()) {
            ModContainer modContainer = (ModContainer)cont.get();
            ArtifactVersion modVersion = modContainer.getModInfo().getVersion();
            VersionRange range = VersionRange.createFromVersion((String)versionRangeString);
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(versionRangeString);
            return requiredVersion.compareTo(modVersion) > 0;
        }
        return true;
    }
}

