/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.base.Preconditions;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketHandlerClient;
import forestry.core.network.PacketHandlerServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;

public class NetworkUtil {
    public static <P extends IForestryPacketClient> void sendNetworkPacket(P packet, BlockPos pos, World world) {
        if (!(world instanceof ServerWorld)) {
            return;
        }
        ServerWorld worldServer = (ServerWorld)world;
        for (PlayerEntity playerObj : world.func_217369_A()) {
            if (!(playerObj instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity player = (ServerPlayerEntity)playerObj;
            NetworkUtil.sendToPlayer(packet, (PlayerEntity)player);
        }
    }

    public static void sendToPlayer(IForestryPacketClient packet, PlayerEntity PlayerEntity2) {
        if (!(PlayerEntity2 instanceof ServerPlayerEntity) || PlayerEntity2 instanceof FakePlayer) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)PlayerEntity2;
        PacketHandlerServer.sendPacket(packet, player);
    }

    public static void inventoryChangeNotify(PlayerEntity player, Container container) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71120_a(container);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(IForestryPacketServer packet) {
        ClientPlayNetHandler netHandler = Minecraft.func_71410_x().func_147114_u();
        Preconditions.checkNotNull((Object)netHandler, (Object)"Tried to send packet before netHandler (client world) exists.");
        PacketHandlerClient.sendPacket(packet);
    }
}

