/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import forestry.core.utils.Translator;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public abstract class PlayerUtil {
    private static final UUID emptyUUID = new UUID(0L, 0L);

    public static boolean isSameGameProfile(GameProfile player1, GameProfile player2) {
        UUID id1 = player1.getId();
        UUID id2 = player2.getId();
        if (id1 != null && id2 != null && !id1.equals(emptyUUID) && !id2.equals(emptyUUID)) {
            return id1.equals(id2);
        }
        return player1.getName() != null && player1.getName().equals(player2.getName());
    }

    public static String getOwnerName(@Nullable GameProfile profile) {
        if (profile == null) {
            return Translator.translateToLocal("for.gui.derelict");
        }
        return profile.getName();
    }

    public static boolean actOnServer(PlayerEntity player, Consumer<ServerPlayerEntity> action) {
        if (player.field_70170_p.field_72995_K || !(player instanceof ServerPlayerEntity)) {
            return false;
        }
        action.accept(PlayerUtil.asServer(player));
        return true;
    }

    public static ClientPlayerEntity asClient(PlayerEntity player) {
        if (!(player instanceof ClientPlayerEntity)) {
            throw new IllegalStateException("Failed to cast player to its client version.");
        }
        return (ClientPlayerEntity)player;
    }

    public static ServerPlayerEntity asServer(PlayerEntity player) {
        if (!(player instanceof ServerPlayerEntity)) {
            throw new IllegalStateException("Failed to cast player to its server version.");
        }
        return (ServerPlayerEntity)player;
    }

    @Nullable
    public static PlayerEntity getPlayer(World world, @Nullable GameProfile profile) {
        if (profile == null || profile.getName() == null) {
            if (world instanceof ServerWorld) {
                return FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
            }
            return null;
        }
        PlayerEntity player = world.func_217371_b(profile.getId());
        if (player == null && world instanceof ServerWorld) {
            player = FakePlayerFactory.get((ServerWorld)((ServerWorld)world), (GameProfile)profile);
        }
        return player;
    }

    @Nullable
    public static PlayerEntity getFakePlayer(World world, @Nullable GameProfile profile) {
        if (profile == null || profile.getName() == null) {
            if (world instanceof ServerWorld) {
                return FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
            }
            return null;
        }
        if (world instanceof ServerWorld) {
            return FakePlayerFactory.get((ServerWorld)((ServerWorld)world), (GameProfile)profile);
        }
        return null;
    }
}

