/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.ClientUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public final class RecipeUtils {
    private RecipeUtils() {
    }

    @Nullable
    public static RecipeManager getRecipeManager(@Nullable World world) {
        RecipeManager manager = (RecipeManager)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> ClientUtils::getRecipeManager);
        return manager != null ? manager : (world != null ? world.func_199532_z() : null);
    }

    @Nullable
    public static <C extends IInventory, T extends IRecipe<C>> IRecipe<C> getRecipe(IRecipeType<T> recipeType, ResourceLocation name, @Nullable World world) {
        RecipeManager manager = RecipeUtils.getRecipeManager(world);
        if (manager == null) {
            return null;
        }
        return (IRecipe)manager.func_215366_a(recipeType).get(name);
    }

    public static <C extends IInventory, T extends IRecipe<C>> List<T> getRecipes(IRecipeType<T> recipeType, C inventory, @Nullable World world) {
        RecipeManager manager = RecipeUtils.getRecipeManager(world);
        if (manager == null || world == null) {
            return Collections.emptyList();
        }
        return manager.func_215370_b(recipeType, inventory, world);
    }

    public static List<ICraftingRecipe> findMatchingRecipes(CraftingInventory inventory, World world) {
        return world.func_199532_z().func_215370_b(IRecipeType.field_222149_a, (IInventory)inventory, world).stream().filter(recipe -> recipe.func_77569_a((IInventory)inventory, world)).collect(Collectors.toList());
    }
}

