/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.gui.slots.SlotForestry;
import forestry.core.utils.ItemStackUtil;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public abstract class SlotUtil {
    private static final int PLAYER_INVENTORY_SIZE = 36;
    private static final int PLAYER_HOTBAR_SIZE = 9;

    public static boolean isSlotInRange(int slotIndex, int start, int count) {
        return slotIndex >= start && slotIndex < start + count;
    }

    public static ItemStack slotClickPhantom(SlotForestry slot, int mouseButton, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack stack = ItemStack.field_190927_a;
        ItemStack stackSlot = slot.func_75211_c();
        if (!stackSlot.func_190926_b()) {
            stack = stackSlot.func_77946_l();
        }
        if (mouseButton == 2) {
            SlotUtil.fillPhantomSlot(slot, ItemStack.field_190927_a, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            PlayerInventory playerInv = player.field_71071_by;
            ItemStack stackHeld = playerInv.func_70445_o();
            if (stackSlot.func_190926_b()) {
                if (!stackHeld.func_190926_b() && slot.func_75214_a(stackHeld)) {
                    SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld.func_190926_b()) {
                SlotUtil.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
            } else if (slot.func_75214_a(stackHeld)) {
                if (ItemStackUtil.isIdenticalItem(stackSlot, stackHeld)) {
                    SlotUtil.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
                } else {
                    SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            }
        } else if (mouseButton == 5) {
            PlayerInventory playerInv = player.field_71071_by;
            ItemStack stackHeld = playerInv.func_70445_o();
            if (!slot.func_75216_d()) {
                SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        }
        return stack;
    }

    public static ItemStack transferStackInSlot(List<Slot> inventorySlots, PlayerEntity player, int slotIndex) {
        Slot slot = inventorySlots.get(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        boolean fromCraftingSlot = slot instanceof CraftingResultSlot;
        int numSlots = inventorySlots.size();
        ItemStack stackInSlot = slot.func_75211_c();
        ItemStack originalStack = stackInSlot.func_77946_l();
        if (!SlotUtil.shiftItemStack(inventorySlots, stackInSlot, slotIndex, numSlots, fromCraftingSlot)) {
            return ItemStack.field_190927_a;
        }
        slot.func_75220_a(stackInSlot, originalStack);
        if (stackInSlot.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (stackInSlot.func_190916_E() == originalStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(player, stackInSlot);
        return originalStack;
    }

    private static boolean shiftItemStack(List<Slot> inventorySlots, ItemStack stackInSlot, int slotIndex, int numSlots, boolean fromCraftingSlot) {
        if (SlotUtil.isInPlayerInventory(slotIndex)) {
            if (SlotUtil.shiftToMachineInventory(inventorySlots, stackInSlot, numSlots)) {
                return true;
            }
            if (SlotUtil.isInPlayerHotbar(slotIndex)) {
                return SlotUtil.shiftToPlayerInventoryNoHotbar(inventorySlots, stackInSlot);
            }
            return SlotUtil.shiftToHotbar(inventorySlots, stackInSlot);
        }
        if (fromCraftingSlot && SlotUtil.shiftToMachineInventory(inventorySlots, stackInSlot, numSlots)) {
            return true;
        }
        return SlotUtil.shiftToPlayerInventory(inventorySlots, stackInSlot);
    }

    private static void adjustPhantomSlot(SlotForestry slot, int mouseButton, ClickType clickTypeIn) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.func_190916_E() + 1) / 2 : stackSlot.func_190916_E() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.func_190916_E() - 1 : stackSlot.func_190916_E() + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.func_190920_e(stackSize);
        slot.func_75215_d(stackSlot);
    }

    private static void fillPhantomSlot(SlotForestry slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        if (stackHeld.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.func_190916_E() : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.func_190920_e(stackSize);
        slot.func_75215_d(phantomStack);
    }

    private static boolean shiftItemStackToRange(List<Slot> inventorySlots, ItemStack stackToShift, int start, int count) {
        boolean changed = SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackToShift, start, count);
        return changed |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackToShift, start, count);
    }

    private static boolean shiftItemStackToRangeMerge(List<Slot> inventorySlots, ItemStack stackToShift, int start, int count) {
        if (!stackToShift.func_77985_e() || stackToShift.func_190926_b()) {
            return false;
        }
        boolean changed = false;
        for (int slotIndex = start; !stackToShift.func_190926_b() && slotIndex < start + count; ++slotIndex) {
            int max;
            Slot slot = inventorySlots.get(slotIndex);
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot.func_190926_b() || !ItemStackUtil.isIdenticalItem(stackInSlot, stackToShift)) continue;
            int resultingStackSize = stackInSlot.func_190916_E() + stackToShift.func_190916_E();
            if (resultingStackSize <= (max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a()))) {
                stackToShift.func_190920_e(0);
                stackInSlot.func_190920_e(resultingStackSize);
                slot.func_75218_e();
                changed = true;
                continue;
            }
            if (stackInSlot.func_190916_E() >= max) continue;
            stackToShift.func_190918_g(max - stackInSlot.func_190916_E());
            stackInSlot.func_190920_e(max);
            slot.func_75218_e();
            changed = true;
        }
        return changed;
    }

    private static boolean shiftItemStackToRangeOpenSlots(List<Slot> inventorySlots, ItemStack stackToShift, int start, int count) {
        if (stackToShift.func_190926_b()) {
            return false;
        }
        boolean changed = false;
        for (int slotIndex = start; !stackToShift.func_190926_b() && slotIndex < start + count; ++slotIndex) {
            Slot slot = inventorySlots.get(slotIndex);
            ItemStack stackInSlot = slot.func_75211_c();
            if (!stackInSlot.func_190926_b()) continue;
            int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
            stackInSlot = stackToShift.func_77946_l();
            stackInSlot.func_190920_e(Math.min(stackToShift.func_190916_E(), max));
            stackToShift.func_190918_g(stackInSlot.func_190916_E());
            slot.func_75215_d(stackInSlot);
            slot.func_75218_e();
            changed = true;
        }
        return changed;
    }

    private static boolean isInPlayerInventory(int slotIndex) {
        return slotIndex < 36;
    }

    private static boolean isInPlayerHotbar(int slotIndex) {
        return SlotUtil.isSlotInRange(slotIndex, 27, 36);
    }

    private static boolean shiftToPlayerInventory(List<Slot> inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        boolean shifted = SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackInSlot, playerHotbarStart, 9);
        shifted |= SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackInSlot, 0, playerHotbarStart);
        shifted |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackInSlot, playerHotbarStart, 9);
        return shifted |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToPlayerInventoryNoHotbar(List<Slot> inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotUtil.shiftItemStackToRange(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToHotbar(List<Slot> inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotUtil.shiftItemStackToRange(inventorySlots, stackInSlot, playerHotbarStart, 9);
    }

    private static boolean shiftToMachineInventory(List<Slot> inventorySlots, ItemStack stackToShift, int numSlots) {
        boolean success = false;
        if (stackToShift.func_77985_e()) {
            success = SlotUtil.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, true);
        }
        if (!stackToShift.func_190926_b()) {
            success |= SlotUtil.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, false);
        }
        return success;
    }

    private static boolean shiftToMachineInventory(List<Slot> inventorySlots, ItemStack stackToShift, int numSlots, boolean mergeOnly) {
        for (int machineIndex = 36; machineIndex < numSlots; ++machineIndex) {
            SlotForestry slotForestry;
            Slot slot = inventorySlots.get(machineIndex);
            if (mergeOnly && slot.func_75211_c().func_190926_b() || slot instanceof SlotForestry && (!(slotForestry = (SlotForestry)slot).canShift() || slotForestry.isPhantom()) || !slot.func_75214_a(stackToShift) || !SlotUtil.shiftItemStackToRange(inventorySlots, stackToShift, machineIndex, 1)) continue;
            return true;
        }
        return false;
    }
}

