/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.function.Supplier;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TranslationTextComponent;

public class Translator {
    private Translator() {
    }

    public static String translateToLocal(String key) {
        return LanguageMap.func_74808_a().func_230503_a_(key);
    }

    public static boolean canTranslateToLocal(String key) {
        return LanguageMap.func_74808_a().func_230506_b_(key);
    }

    public static String translateToLocalFormatted(String key, Object ... format) {
        return new TranslationTextComponent(key, format).getString();
    }

    public static ITextComponent tryTranslate(String optionalKey, String defaultKey) {
        return Translator.tryTranslate(() -> new TranslationTextComponent(optionalKey), () -> new TranslationTextComponent(defaultKey));
    }

    public static ITextComponent tryTranslate(String optionalKey, Supplier<ITextComponent> defaultKey) {
        return Translator.tryTranslate(() -> new TranslationTextComponent(optionalKey), defaultKey);
    }

    private static ITextComponent tryTranslate(Supplier<TranslationTextComponent> optionalKey, Supplier<ITextComponent> defaultKey) {
        TranslationTextComponent component = optionalKey.get();
        if (Translator.canTranslate(component)) {
            return component;
        }
        return defaultKey.get();
    }

    public static boolean canTranslate(TranslationTextComponent component) {
        String translatedText = component.getString();
        return !translatedText.startsWith(component.func_150268_i());
    }
}

