/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;

public class VillagerJigsaw {
    public static void init() {
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        VillagerJigsaw.addVillagerHouse("apiarist", "plains", 6);
        VillagerJigsaw.addVillagerHouse("apiarist", "snowy", 4);
        VillagerJigsaw.addVillagerHouse("apiarist", "savanna", 6);
        VillagerJigsaw.addVillagerHouse("apiarist", "desert", 5);
        VillagerJigsaw.addVillagerHouse("apiarist", "taiga", 7);
    }

    private static void addVillagerHouse(String type, String biome, int weight) {
        VillagerJigsaw.addToJigsawPattern(new ResourceLocation("village/" + biome + "/houses"), (JigsawPiece)JigsawPiece.func_242849_a((String)("forestry:village/" + type + "_house_" + biome + "_1")).apply(JigsawPattern.PlacementBehaviour.RIGID), weight);
    }

    public static void addToJigsawPattern(ResourceLocation toAdd, JigsawPiece newPiece, int weight) {
        JigsawPattern oldPool = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(toAdd);
        if (oldPool != null) {
            oldPool.field_214952_d.add(Pair.of((Object)newPiece, (Object)weight));
            List jigsawPieces = oldPool.field_214953_e;
            for (int i = 0; i < weight; ++i) {
                jigsawPieces.add(newPiece);
            }
        }
    }
}

