/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.farming.FarmDirection;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.ColourProperties;
import forestry.cultivation.inventory.InventoryPlanter;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GhostItemStackWidget
extends ItemStackWidget {
    private final Slot slot;

    public GhostItemStackWidget(WidgetManager widgetManager, int xPos, int yPos, ItemStack itemStack, Slot slot) {
        super(widgetManager, xPos, yPos, itemStack);
        this.slot = slot;
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        if (!this.slot.func_75216_d()) {
            super.draw(transform, startY, startX);
        }
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        ITextComponent directionString = this.getDirectionString();
        if (directionString == StringTextComponent.field_240750_d_) {
            FontRenderer fontRenderer = this.manager.minecraft.field_71466_p;
            fontRenderer.func_243246_a(transform, this.getDirectionString(), (float)(this.xPos + startX + 5), (float)(this.yPos + startY + 4), ColourProperties.INSTANCE.get("gui.screen"));
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(this.manager.gui.textureFile);
        this.manager.gui.func_238474_b_(transform, this.xPos + startX, this.yPos + startY, 206, 0, 16, 16);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.enableLighting();
    }

    private ITextComponent getDirectionString() {
        if (this.slot.getSlotIndex() >= InventoryPlanter.CONFIG.productionStart || this.slot.getSlotIndex() < InventoryPlanter.CONFIG.productionStart + InventoryPlanter.CONFIG.productionCount) {
            return StringTextComponent.field_240750_d_;
        }
        int index = this.slot.getSlotIndex() % 4;
        FarmDirection direction = FarmDirection.values()[index];
        String directionString = direction.toString().toLowerCase(Locale.ENGLISH);
        return new TranslationTextComponent("for.gui.planter." + directionString);
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return null;
    }
}

