/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.tiles;

import com.google.common.base.Preconditions;
import forestry.api.climate.IClimatised;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.core.config.Config;
import forestry.core.fluids.ITankManager;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.VectUtil;
import forestry.cultivation.IFarmHousingInternal;
import forestry.cultivation.blocks.BlockPlanter;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.gui.ContainerPlanter;
import forestry.cultivation.inventory.InventoryPlanter;
import forestry.farming.FarmHelper;
import forestry.farming.FarmManager;
import forestry.farming.FarmRegistry;
import forestry.farming.FarmTarget;
import forestry.farming.gui.IFarmLedgerDelegate;
import forestry.farming.multiblock.IFarmInventoryInternal;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class TilePlanter
extends TilePowered
implements IFarmHousingInternal,
IClimatised,
ILiquidTankTile,
IOwnedTile,
IStreamableGui {
    private final InventoryPlanter inventory;
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private final FarmManager manager;
    private BlockPlanter.Mode mode;
    private final IFarmProperties properties;
    @Nullable
    private IFarmLogic logic;
    @Nullable
    private Vector3i offset;
    @Nullable
    private Vector3i area;

    public void setManual(BlockPlanter.Mode mode) {
        this.mode = mode;
        this.logic = this.properties.getLogic(this.mode == BlockPlanter.Mode.MANUAL);
    }

    protected TilePlanter(TileEntityType type, String identifier) {
        super(type, 150, 1500);
        this.properties = (IFarmProperties)Preconditions.checkNotNull((Object)FarmRegistry.getInstance().getProperties(identifier));
        this.mode = BlockPlanter.Mode.MANAGED;
        this.inventory = new InventoryPlanter(this);
        this.setInternalInventory(this.inventory);
        this.manager = new FarmManager(this);
        this.setEnergyPerWorkCycle(10);
        this.setTicksPerWorkCycle(2);
    }

    @Override
    public ITextComponent func_145748_c_() {
        String name = this.getBlockType(BlockTypePlanter.ARBORETUM).func_176610_l();
        return new TranslationTextComponent("block.forestry.planter." + this.mode.func_176610_l(), new Object[]{new TranslationTextComponent("block.forestry." + name)});
    }

    @Override
    public boolean hasWork() {
        return true;
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        this.manager.getHydrationManager().updateServer();
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.manager.getTankManager());
        }
    }

    @Override
    protected boolean workCycle() {
        this.manager.doWork();
        return false;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        data = super.func_189515_b(data);
        this.manager.write(data);
        this.ownerHandler.write(data);
        data.func_74768_a("mode", this.mode.ordinal());
        return data;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
        this.manager.read(data);
        this.ownerHandler.read(data);
        this.setManual(BlockPlanter.Mode.values()[data.func_74762_e("mode")]);
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        this.manager.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.manager.readData(data);
    }

    @Override
    public void setUpFarmlandTargets(Map<FarmDirection, List<FarmTarget>> targets) {
        BlockPos targetStart = this.getCoords();
        BlockPos minPos = this.field_174879_c;
        BlockPos maxPos = this.field_174879_c;
        int size = 1;
        int extend = Config.planterExtend;
        if (Config.ringFarms) {
            int ringSize = Config.ringSize;
            minPos = this.field_174879_c.func_177982_a(-ringSize, 0, -ringSize);
            maxPos = this.field_174879_c.func_177982_a(ringSize, 0, ringSize);
            size = 1 + ringSize * 2;
            --extend;
        }
        FarmHelper.createTargets(this.field_145850_b, this, targets, targetStart, extend, size, size, minPos, maxPos);
        FarmHelper.setExtents(this.field_145850_b, this, targets);
    }

    @Override
    public BlockPos getCoords() {
        return this.field_174879_c;
    }

    @Override
    public BlockPos getTopCoord() {
        return this.field_174879_c;
    }

    @Override
    public Vector3i getArea() {
        if (this.area == null) {
            int basisArea = 5;
            if (Config.ringFarms) {
                basisArea = basisArea + 1 + Config.ringSize * 2;
            }
            this.area = new Vector3i(basisArea + Config.planterExtend, 13, basisArea + Config.planterExtend);
        }
        return this.area;
    }

    @Override
    public Vector3i getOffset() {
        if (this.offset == null) {
            Vector3i area = this.getArea();
            this.offset = new Vector3i(-area.func_177958_n() / 2, -2, -area.func_177952_p() / 2);
        }
        return this.offset;
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean hasLiquid(FluidStack liquid) {
        FluidStack drained = this.manager.getResourceTank().drainInternal(liquid, IFluidHandler.FluidAction.SIMULATE);
        return liquid.isFluidStackIdentical(drained);
    }

    @Override
    public void removeLiquid(FluidStack liquid) {
        this.manager.getResourceTank().drain(liquid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public boolean plantGermling(IFarmable farmable, World world, BlockPos pos, FarmDirection direction) {
        PlayerEntity player = PlayerUtil.getFakePlayer(world, this.getOwnerHandler().getOwner());
        return player != null && this.inventory.plantGermling(farmable, player, pos, direction);
    }

    @Override
    public boolean isValidPlatform(World world, BlockPos pos) {
        return pos.func_177956_o() == this.func_174877_v().func_177956_o() - 2;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean canPlantSoil(boolean manual) {
        return this.mode == BlockPlanter.Mode.MANAGED;
    }

    @Override
    public IFarmInventoryInternal getFarmInventory() {
        return this.inventory;
    }

    @Override
    public void addPendingProduct(ItemStack stack) {
        this.manager.addPendingProduct(stack);
    }

    @Override
    public void setFarmLogic(FarmDirection direction, IFarmLogic logic) {
    }

    @Override
    public void resetFarmLogic(FarmDirection direction) {
    }

    @Override
    public IFarmLogic getFarmLogic(FarmDirection direction) {
        return this.getFarmLogic();
    }

    public IFarmLogic getFarmLogic() {
        return this.logic;
    }

    @Override
    public Collection<IFarmLogic> getFarmLogics() {
        return Collections.singleton(this.logic);
    }

    @Override
    public int getStoredFertilizerScaled(int scale) {
        return this.manager.getFertilizerManager().getStoredFertilizerScaled(this.inventory, scale);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.manager.clearTargets();
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT data = super.func_189517_E_();
        this.manager.write(data);
        return data;
    }

    protected final BlockPos translateWithOffset(BlockPos pos, FarmDirection farmDirection, int step) {
        return VectUtil.scale(farmDirection.getFacing().func_176730_m(), step).func_177971_a((Vector3i)pos);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerPlanter(windowId, inv, this);
    }

    public IFarmLedgerDelegate getFarmLedgerDelegate() {
        return this.manager.getHydrationManager();
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        BlockPos coords = this.getCoordinates();
        return this.field_145850_b.func_226691_t_(coords).func_225486_c(coords);
    }

    @Override
    public float getExactHumidity() {
        BlockPos coords = this.getCoordinates();
        return this.field_145850_b.func_226691_t_(coords).func_76727_i();
    }

    @Override
    public ITankManager getTankManager() {
        return this.manager.getTankManager();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(this::getTankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    protected NonNullList<ItemStack> createList(ItemStack ... stacks) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])stacks);
    }

    public abstract NonNullList<ItemStack> createGermlingStacks();

    public abstract NonNullList<ItemStack> createResourceStacks();

    public abstract NonNullList<ItemStack> createProductionStacks();

    @Override
    public BlockPos getFarmCorner(FarmDirection direction) {
        return this.field_174879_c.func_177979_c(2);
    }

    @Override
    public int getExtents(FarmDirection direction, BlockPos pos) {
        return this.manager.getExtents(direction, pos);
    }

    @Override
    public void setExtents(FarmDirection direction, BlockPos pos, int extend) {
        this.manager.setExtents(direction, pos, extend);
    }

    @Override
    public void cleanExtents(FarmDirection direction) {
        this.manager.cleanExtents(direction);
    }
}

