/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.gui;

import forestry.core.gui.ContainerAnalyzerProvider;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TileUtil;
import forestry.database.features.DatabaseContainers;
import forestry.database.tiles.TileDatabase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContainerDatabase
extends ContainerAnalyzerProvider<TileDatabase> {
    public static ContainerDatabase fromNetwork(int windowId, PlayerInventory inv, PacketBuffer data) {
        PacketBufferForestry buf = new PacketBufferForestry((ByteBuf)data);
        TileDatabase tile = TileUtil.getTile((IBlockReader)inv.field_70458_d.field_70170_p, buf.func_179259_c(), TileDatabase.class);
        return new ContainerDatabase(windowId, inv, tile);
    }

    public ContainerDatabase(int windowId, PlayerInventory playerInventory, TileDatabase tileForestry) {
        super(windowId, DatabaseContainers.DATABASE.containerType(), playerInventory, tileForestry, 29, 120);
        ContainerDatabase.addInventory(this, tileForestry);
    }

    private static void addInventory(ContainerForestry container, TileDatabase inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            container.func_75146_a(new SlotFilteredInventory(inventory, i, -10000, -10000));
        }
    }

    public void sendContainerToListeners() {
        for (IContainerListener listener : this.field_75149_d) {
            listener.func_71110_a((Container)this, this.func_75138_a());
        }
    }

    public IItemHandler getItemHandler() {
        return new InvWrapper((IInventory)((TileDatabase)this.tile).getInternalInventory());
    }
}

