/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiAnalyzerProvider;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.core.tiles.ITitled;
import forestry.database.DatabaseHelper;
import forestry.database.DatabaseItem;
import forestry.database.gui.ContainerDatabase;
import forestry.database.gui.buttons.DatabaseButton;
import forestry.database.gui.buttons.GuiDatabaseButton;
import forestry.database.gui.widgets.WidgetDatabaseSlot;
import forestry.database.tiles.TileDatabase;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiDatabase
extends GuiAnalyzerProvider<ContainerDatabase>
implements IScrollable {
    private static final ResourceLocation CREATIVE_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final Drawable SCROLLBAR_SLIDER = new Drawable(CREATIVE_TABS, 232, 0, 12, 15);
    public final TileDatabase tile;
    private final ArrayList<WidgetDatabaseSlot> slots;
    private final ArrayList<DatabaseItem> sorted = new ArrayList();
    @Nullable
    private TextFieldWidget searchField;
    private WidgetScrollBar scrollBar;
    private boolean markedForSorting;
    @Nullable
    private DatabaseItem selectedItem;

    public GuiDatabase(ContainerDatabase container, PlayerInventory inv, ITextComponent title) {
        super("textures/gui/database_inventory.png", container, inv, (ITitled)container.getTile(), 7, 140, 20, true, ((TileDatabase)container.getTile()).getInternalInventory().func_70302_i_(), 0);
        this.tile = (TileDatabase)container.getTile();
        this.slots = new ArrayList();
        this.field_146999_f = 218;
        this.field_147000_g = 202;
        ListIterator slotIterator = container.field_75151_b.listIterator(36);
        while (slotIterator.hasNext()) {
            Slot slot = (Slot)slotIterator.next();
            if (!(slot instanceof SlotFilteredInventory)) continue;
            SlotFilteredInventory slotDatabase = (SlotFilteredInventory)slot;
            slotDatabase.setChangeWatcher(this);
        }
        for (int i = 0; i < 24; ++i) {
            WidgetDatabaseSlot slot = new WidgetDatabaseSlot(this.widgetManager);
            this.slots.add(slot);
            this.widgetManager.add(slot);
        }
        this.scrollBar = new WidgetScrollBar(this.widgetManager, 196, 19, 12, 90, SCROLLBAR_SLIDER);
        this.widgetManager.add(this.scrollBar);
        this.scrollBar.setParameters(this, 0, this.tile.func_70302_i_() / 4 - 6, 1);
        this.analyzer.init();
        this.analyzer.setSelectedSlot(-1);
    }

    @Nullable
    public DatabaseItem getSelectedItem() {
        return this.selectedItem;
    }

    public int getSize() {
        return this.sorted.size() - 1;
    }

    public int getRealSize() {
        return this.sorted.size();
    }

    public ItemStack getSelectedItemStack() {
        if (this.selectedItem == null) {
            return ItemStack.field_190927_a;
        }
        return this.selectedItem.itemStack;
    }

    public void markForSorting() {
        this.markedForSorting = true;
    }

    private void updateItems(String searchText) {
        if (this.markedForSorting) {
            this.sorted.clear();
            ArrayList<DatabaseItem> items = new ArrayList<DatabaseItem>();
            boolean firstEmpty = false;
            for (int invIndex = 0; invIndex < this.tile.func_70302_i_(); ++invIndex) {
                ItemStack stack = this.tile.func_70301_a(invIndex).func_77946_l();
                if (!stack.func_190926_b()) {
                    items.add(new DatabaseItem(stack, invIndex));
                    continue;
                }
                if (firstEmpty) continue;
                firstEmpty = true;
                items.add(new DatabaseItem(stack, invIndex));
            }
            DatabaseHelper.update(searchText, items, this.sorted);
            this.analyzer.updateSelected();
            this.updateViewedItems();
            this.markedForSorting = false;
        }
    }

    @Nullable
    public DatabaseItem getItem(int index) {
        if (this.sorted.isEmpty() || this.sorted.size() <= index || index < 0) {
            return null;
        }
        return this.sorted.get(index);
    }

    private void updateViewedItems() {
        int currentRow = this.scrollBar.getValue();
        if (currentRow < 0) {
            currentRow = 0;
        }
        int slotStart = currentRow * 4;
        int slotEnd = (currentRow + 6) * 4;
        if (slotEnd > this.tile.func_70302_i_()) {
            slotEnd = this.tile.func_70302_i_();
        }
        byte startRow = (byte)(currentRow % 2);
        int emptySlot = this.sorted.size() - 1;
        for (int invIndex = 0; invIndex < this.tile.func_70302_i_(); ++invIndex) {
            int xOffset;
            if (invIndex < slotStart || invIndex >= slotEnd) continue;
            int x = invIndex % 4;
            int y = invIndex / 4 - currentRow;
            int yOffset = 25;
            if (startRow == 0) {
                xOffset = 17;
                if (y % 2 == 1) {
                    xOffset = 38;
                    yOffset = 38;
                    --y;
                }
            } else {
                xOffset = 38;
                if (y % 2 == 1) {
                    yOffset = 38;
                    xOffset = 17;
                    --y;
                }
            }
            int xPos = xOffset + x * 42;
            int yPos = yOffset + y / 2 * 25;
            int index = invIndex;
            if (this.sorted.size() <= index || this.sorted.isEmpty()) {
                index = emptySlot;
            }
            WidgetDatabaseSlot slot = this.slots.get(invIndex - slotStart);
            slot.update(xPos, yPos, index, index != emptySlot);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.searchField.func_146178_a();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        FontRenderer fontRenderer = this.field_230706_i_.field_71466_p;
        this.field_230706_i_.field_71466_p.getClass();
        this.searchField = new TextFieldWidget(fontRenderer, this.field_147003_i + 101, this.field_147009_r + 6, 80, 9, null);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xFFFFFF);
        this.field_230705_e_.add(this.searchField);
        this.func_230480_a_((Widget)new GuiDatabaseButton<Boolean>(this.field_147003_i - 18, this.field_147009_r, DatabaseHelper.ascending, this, DatabaseButton.SORT_DIRECTION_BUTTON, b -> ((GuiDatabaseButton)b).onPressed()));
        this.updateViewedItems();
    }

    @Override
    public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float partialTicks) {
        String searchText = this.searchField != null ? this.searchField.func_146179_b() : "";
        this.updateItems(searchText);
        super.func_230430_a_(transform, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        if (this.searchField != null && (this.searchField.func_231046_a_(key, scanCode, modifiers) || this.searchField.func_212955_f())) {
            this.scrollBar.setValue(0);
            this.markForSorting();
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    @Override
    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (super.func_231042_a_(codePoint, modifiers)) {
            if (this.func_241217_q_() == this.searchField) {
                this.scrollBar.setValue(0);
                this.markForSorting();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        if (slot != null && slot.getSlotIndex() == -1) {
            return false;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(transform, partialTicks, mouseX, mouseY);
        if (this.searchField != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableLighting();
            this.searchField.func_230430_a_(transform, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void drawBackground(MatrixStack transform) {
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    protected void addLedgers() {
    }

    @Override
    protected boolean centeredTitle() {
        return false;
    }

    @Override
    protected void drawSelectedSlot(MatrixStack transform, int selectedSlot) {
    }

    @Override
    public ItemStack getSpecimen(int index) {
        DatabaseItem item = this.getSelectedItem();
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return item.itemStack;
    }

    @Override
    public boolean onUpdateSelected() {
        int index;
        int n = index = this.selectedItem == null ? -1 : this.sorted.indexOf(this.selectedItem);
        if (index >= 0) {
            this.analyzer.setSelectedSlot(index);
            return true;
        }
        return false;
    }

    @Override
    public void onSelection(int index, boolean changed) {
        this.selectedItem = index < 0 ? null : (this.sorted != null && index >= this.sorted.size() ? null : this.sorted.get(index));
    }

    @Override
    public int getSelectedSlot(int index) {
        DatabaseItem item = this.getItem(index);
        if (item == null) {
            return -1;
        }
        return 1 + item.invIndex;
    }

    @Override
    public void onScroll(int value) {
        this.updateViewedItems();
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.func_195359_a(0, 0, this.field_146999_f, this.field_147000_g, mouseX + this.field_147003_i, mouseY + this.field_147009_r);
    }

    @Override
    public void onSlotChanged(IInventory inventory, int slot) {
        super.onSlotChanged(inventory, slot);
        this.markForSorting();
    }
}

