/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.config.Config;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyTransferMode;
import forestry.energy.compat.EnergyStorageWrapper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyManager
extends EnergyStorage
implements IStreamable,
INbtReadable,
INbtWritable {
    private EnergyTransferMode externalMode = EnergyTransferMode.BOTH;

    public EnergyManager(int maxTransfer, int capacity) {
        super(EnergyHelper.scaleForDifficulty(capacity), EnergyHelper.scaleForDifficulty(maxTransfer), EnergyHelper.scaleForDifficulty(maxTransfer));
    }

    public void setExternalMode(EnergyTransferMode externalMode) {
        this.externalMode = externalMode;
    }

    public EnergyTransferMode getExternalMode() {
        return this.externalMode;
    }

    @Override
    public void read(CompoundNBT nbt) {
        int energy;
        if (nbt.func_74764_b("EnergyManager")) {
            CompoundNBT energyManagerNBT = nbt.func_74775_l("EnergyManager");
            CompoundNBT energyStorageNBT = energyManagerNBT.func_74775_l("EnergyStorage");
            energy = energyStorageNBT.func_74762_e("Energy");
        } else {
            energy = nbt.func_74762_e("Energy");
        }
        this.setEnergyStored(energy);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.func_150787_b(this.energy);
    }

    @Override
    public void readData(PacketBufferForestry data) {
        int energyStored = data.func_150792_a();
        this.setEnergyStored(energyStored);
    }

    public int getMaxEnergyReceived() {
        return this.maxReceive;
    }

    public void drainEnergy(int amount) {
        this.setEnergyStored(this.energy - amount);
    }

    public void generateEnergy(int amount) {
        this.setEnergyStored(this.energy + amount);
    }

    public void setEnergyStored(int energyStored) {
        this.energy = energyStored;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public boolean hasCapability(Capability<?> capability) {
        return Config.enableRF && capability == CapabilityEnergy.ENERGY || Config.enableTesla && this.hasTeslaCapability(capability) || Config.enableMJ && this.hasMjCapability(capability);
    }

    private boolean hasTeslaCapability(Capability<?> capability) {
        return false;
    }

    private boolean hasMjCapability(Capability<?> capability) {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (!this.hasCapability(capability)) {
            return LazyOptional.empty();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            EnergyStorageWrapper energyStorage = new EnergyStorageWrapper(this, this.externalMode);
            return LazyOptional.of(() -> energyStorage).cast();
        }
        return LazyOptional.empty();
    }

    public int calculateRedstone() {
        return MathHelper.func_76141_d((float)((float)this.energy / (float)this.capacity * 14.0f)) + (this.energy > 0 ? 1 : 0);
    }
}

