/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import forestry.core.blocks.IBlockTypeTesr;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.blocks.MachineProperties;
import forestry.core.blocks.MachinePropertiesTesr;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileBase;
import forestry.energy.ModuleEnergy;
import forestry.energy.features.EnergyTiles;
import forestry.energy.tiles.TileEngine;
import forestry.modules.features.FeatureTileType;
import java.util.function.Supplier;

public enum BlockTypeEngine implements IBlockTypeTesr
{
    PEAT(BlockTypeEngine.createEngineProperties(() -> EnergyTiles.PEAT_ENGINE, "peat", "/engine_copper")),
    BIOGAS(BlockTypeEngine.createEngineProperties(() -> EnergyTiles.BIOGAS_ENGINE, "biogas", "/engine_bronze")),
    CLOCKWORK(BlockTypeEngine.createEngineProperties(() -> EnergyTiles.CLOCKWORK_ENGINE, "clockwork", "/engine_clock"));

    public static final BlockTypeEngine[] VALUES;
    private final IMachinePropertiesTesr<?> machineProperties;

    private BlockTypeEngine(IMachinePropertiesTesr<?> machineProperties) {
        this.machineProperties = machineProperties;
    }

    protected static IMachinePropertiesTesr<?> createEngineProperties(Supplier<FeatureTileType<? extends TileEngine>> teClass, String name, String textureName) {
        MachineProperties machinePropertiesEngine = new MachinePropertiesTesr.Builder(teClass, name).setParticleTexture(textureName + ".0").setNotFullCube().create();
        ModuleEnergy.proxy.setRenderDefaultEngine((MachinePropertiesTesr<? extends TileEngine>)machinePropertiesEngine, "textures/block" + textureName + "_");
        return machinePropertiesEngine;
    }

    protected static IMachinePropertiesTesr<?> createMachineProperties(Supplier<FeatureTileType<? extends TileBase>> teClass, String name, String textureName) {
        MachineProperties machinePropertiesTesr = new MachinePropertiesTesr.Builder(teClass, name).setParticleTexture(textureName + ".0").create();
        Proxies.render.setRenderDefaultMachine((MachinePropertiesTesr<? extends TileBase>)machinePropertiesTesr, "textures/block" + textureName + "_");
        return machinePropertiesTesr;
    }

    @Override
    public IMachinePropertiesTesr<?> getMachineProperties() {
        return this.machineProperties;
    }

    public String func_176610_l() {
        return this.getMachineProperties().func_176610_l();
    }

    static {
        VALUES = BlockTypeEngine.values();
    }
}

