/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.core.IErrorLogicSource;
import forestry.core.config.Config;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.Translator;
import forestry.energy.tiles.TileEngine;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class GuiEngine<C extends Container, I extends TileEngine>
extends GuiForestryTitled<C> {
    protected final I tile;

    protected GuiEngine(String texture, C container, PlayerInventory inv, I tile, ITextComponent title) {
        super(texture, container, inv, title);
        this.tile = tile;
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger((IErrorLogicSource)this.tile);
        this.addHintLedger(((TileEngine)this.tile).getHintKey());
        this.ledgerManager.add(new EngineLedger());
    }

    protected class EngineLedger
    extends Ledger {
        public EngineLedger() {
            super(GuiEngine.this.ledgerManager, "power");
            this.maxHeight = 94;
        }

        @Override
        public void draw(MatrixStack transform, int y, int x) {
            this.drawBackground(transform, y, x);
            this.drawSprite(transform, TextureManagerForestry.getInstance().getDefault("misc/energy"), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            this.drawHeader(transform, Translator.translateToLocal("for.gui.energy"), x + 22, y + 8);
            this.drawSubheader(transform, Translator.translateToLocal("for.gui.currentOutput") + ':', x + 22, y + 20);
            this.drawText(transform, Config.energyDisplayMode.formatRate(((TileEngine)GuiEngine.this.tile).getCurrentOutput()), x + 22, y + 32);
            this.drawSubheader(transform, Translator.translateToLocal("for.gui.stored") + ':', x + 22, y + 44);
            this.drawText(transform, Config.energyDisplayMode.formatEnergyValue(((TileEngine)GuiEngine.this.tile).getEnergyManager().getEnergyStored()), x + 22, y + 56);
            this.drawSubheader(transform, Translator.translateToLocal("for.gui.heat") + ':', x + 22, y + 68);
            this.drawText(transform, (double)((TileEngine)GuiEngine.this.tile).getHeat() / 10.0 + 20.0 + " C", x + 22, y + 80);
        }

        @Override
        public ITextComponent getTooltip() {
            return new StringTextComponent(Config.energyDisplayMode.formatRate(((TileEngine)GuiEngine.this.tile).getCurrentOutput()));
        }
    }
}

