/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.render;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryResource;
import forestry.core.render.IForestryRenderer;
import forestry.core.render.RenderHelper;
import forestry.core.tiles.TemperatureState;
import forestry.energy.tiles.TileEngine;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderEngine
implements IForestryRenderer<TileEngine> {
    private final ModelRenderer boiler;
    private final ModelRenderer trunk;
    private final ModelRenderer piston;
    private final ModelRenderer extension;
    private ResourceLocation[] textures;
    private static final float[] angleMap = new float[6];

    public RenderEngine(String baseTexture) {
        int textureWidth = 64;
        int textureHeight = 32;
        this.boiler = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.boiler.func_228300_a_(-8.0f, -8.0f, -8.0f, 16.0f, 6.0f, 16.0f);
        this.boiler.field_78800_c = 8.0f;
        this.boiler.field_78797_d = 8.0f;
        this.boiler.field_78798_e = 8.0f;
        this.trunk = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.trunk.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 12.0f, 8.0f);
        this.trunk.field_78800_c = 8.0f;
        this.trunk.field_78797_d = 8.0f;
        this.trunk.field_78798_e = 8.0f;
        this.piston = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.piston.func_228300_a_(-6.0f, -2.0f, -6.0f, 12.0f, 4.0f, 12.0f);
        this.piston.field_78800_c = 8.0f;
        this.piston.field_78797_d = 8.0f;
        this.piston.field_78798_e = 8.0f;
        this.extension = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.extension.func_228300_a_(-5.0f, -3.0f, -5.0f, 10.0f, 2.0f, 10.0f);
        this.extension.field_78800_c = 8.0f;
        this.extension.field_78797_d = 8.0f;
        this.extension.field_78798_e = 8.0f;
        this.textures = new ResourceLocation[]{new ForestryResource(baseTexture + "base.png"), new ForestryResource(baseTexture + "piston.png"), new ForestryResource(baseTexture + "extension.png"), new ForestryResource("textures/block/engine_trunk_highest.png"), new ForestryResource("textures/block/engine_trunk_higher.png"), new ForestryResource("textures/block/engine_trunk_high.png"), new ForestryResource("textures/block/engine_trunk_medium.png"), new ForestryResource("textures/block/engine_trunk_low.png")};
    }

    @Override
    public void renderTile(TileEngine tile, RenderHelper helper) {
        World worldObj = tile.getWorldObj();
        BlockState blockState = worldObj.func_180495_p(tile.func_174877_v());
        if (blockState.func_177230_c() instanceof BlockBase) {
            Direction facing = (Direction)blockState.func_177229_b(BlockBase.FACING);
            this.render(tile.getTemperatureState(), tile.progress, facing, helper);
        }
    }

    @Override
    public void renderItem(ItemStack stack, RenderHelper helper) {
        this.render(TemperatureState.COOL, 0.25f, Direction.UP, helper);
    }

    private void render(TemperatureState state, float progress, Direction orientation, RenderHelper helper) {
        ResourceLocation texture;
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        float step = (double)progress > 0.5 ? 5.99f - (progress - 0.5f) * 2.0f * 5.99f : progress * 2.0f * 5.99f;
        float tfactor = step / 16.0f;
        Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        float[] translate = new float[]{orientation.func_82601_c(), orientation.func_96559_d(), orientation.func_82599_e()};
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                rotation.setZ(angleMap[orientation.ordinal()]);
                break;
            }
            default: {
                rotation.setX(angleMap[orientation.ordinal()]);
            }
        }
        helper.setRotation(rotation);
        helper.renderModel(this.textures[Textures.BASE.ordinal()], this.boiler);
        helper.push();
        helper.translate(translate[0] * tfactor, translate[1] * tfactor, translate[2] * tfactor);
        helper.renderModel(this.textures[Textures.PISTON.ordinal()], this.piston);
        helper.translate(-translate[0] * tfactor, -translate[1] * tfactor, -translate[2] * tfactor);
        switch (state) {
            case OVERHEATING: {
                texture = this.textures[Textures.TRUNK_HIGHEST.ordinal()];
                break;
            }
            case RUNNING_HOT: {
                texture = this.textures[Textures.TRUNK_HIGHER.ordinal()];
                break;
            }
            case OPERATING_TEMPERATURE: {
                texture = this.textures[Textures.TRUNK_HIGH.ordinal()];
                break;
            }
            case WARMED_UP: {
                texture = this.textures[Textures.TRUNK_MEDIUM.ordinal()];
                break;
            }
            default: {
                texture = this.textures[Textures.TRUNK_LOW.ordinal()];
            }
        }
        helper.renderModel(texture, this.trunk);
        float chamberf = 0.125f;
        if (step > 0.0f) {
            int i = 0;
            while ((float)i <= step + 2.0f) {
                helper.renderModel(this.textures[Textures.EXTENSION.ordinal()], this.extension);
                helper.translate(translate[0] * chamberf, translate[1] * chamberf, translate[2] * chamberf);
                i += 2;
            }
        }
        helper.pop();
    }

    static {
        RenderEngine.angleMap[Direction.EAST.ordinal()] = -1.5707964f;
        RenderEngine.angleMap[Direction.WEST.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[Direction.UP.ordinal()] = 0.0f;
        RenderEngine.angleMap[Direction.DOWN.ordinal()] = (float)Math.PI;
        RenderEngine.angleMap[Direction.SOUTH.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[Direction.NORTH.ordinal()] = -1.5707964f;
    }

    private static enum Textures {
        BASE,
        PISTON,
        EXTENSION,
        TRUNK_HIGHEST,
        TRUNK_HIGHER,
        TRUNK_HIGH,
        TRUNK_MEDIUM,
        TRUNK_LOW;

    }
}

