/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.energy.features.EnergyTiles;
import forestry.energy.gui.ContainerEngineBiogas;
import forestry.energy.inventory.InventoryEngineBiogas;
import forestry.energy.tiles.TileEngine;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEngineBiogas
extends TileEngine
implements ISidedInventory,
ILiquidTankTile {
    private final FilteredTank fuelTank;
    private final FilteredTank heatingTank;
    private final StandardTank burnTank;
    private final TankManager tankManager;
    private boolean shutdown;

    public TileEngineBiogas() {
        super(EnergyTiles.BIOGAS_ENGINE.tileType(), "engine.bronze", 10000, 300000);
        this.setInternalInventory(new InventoryEngineBiogas(this));
        this.fuelTank = new FilteredTank(10000).setFilters(FuelManager.bronzeEngineFuel.keySet());
        this.heatingTank = new FilteredTank(10000, true, false).setFilters(new Fluid[]{Fluids.field_204547_b});
        this.burnTank = new StandardTank(1000, false, false);
        this.tankManager = new TankManager(this, this.fuelTank, this.heatingTank, this.burnTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Nullable
    public Fluid getBurnTankFluidType() {
        return this.burnTank.getFluidType();
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        FluidHelper.drainContainers(this.tankManager, (IInventory)this, 0);
        IErrorLogic errorLogic = this.getErrorLogic();
        boolean hasHeat = this.getHeatLevel() > 0.2 || this.heatingTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasHeat, EnumErrorCode.NO_HEAT);
        boolean hasFuel = this.burnTank.getFluidAmount() > 0 || this.fuelTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasFuel, EnumErrorCode.NO_FUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.isRedstoneActivated() && (this.fuelTank.getFluidAmount() >= 1000 || this.burnTank.getFluidAmount() > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.getFluidAmount() > 0 && this.heatingTank.getFluidType() == Fluids.field_204547_b) {
                this.addHeat(20);
                this.heatingTank.drainInternal(1, IFluidHandler.FluidAction.EXECUTE);
            }
            if (heatStage > 0.2) {
                if (this.burnTank.getFluidAmount() > 0) {
                    FluidStack drained = this.burnTank.drainInternal(1, IFluidHandler.FluidAction.EXECUTE);
                    this.currentOutput = TileEngineBiogas.determineFuelValue(drained);
                    this.energyManager.generateEnergy(this.currentOutput);
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                } else {
                    FluidStack fuel = this.fuelTank.drainInternal(1000, IFluidHandler.FluidAction.EXECUTE);
                    int burnTime = TileEngineBiogas.determineBurnTime(fuel);
                    if (!fuel.isEmpty()) {
                        fuel.setAmount(burnTime);
                    }
                    this.burnTank.setCapacity(burnTime);
                    this.burnTank.setFluid(fuel);
                }
            } else {
                this.shutdown(true);
            }
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public int dissipateHeat() {
        EngineBronzeFuel fuel;
        FluidStack fuelFluidStack;
        double heatStage;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if (this.fuelTank.getFluidAmount() > 0 && !(fuelFluidStack = this.fuelTank.getFluid()).isEmpty() && (fuel = FuelManager.bronzeEngineFuel.get(fuelFluidStack.getFluid())) != null) {
            loss *= fuel.getDissipationMultiplier();
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int generate = 0;
        if (this.isRedstoneActivated() && this.burnTank.getFluidAmount() > 0) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
        return generate;
    }

    private static int determineFuelValue(@Nullable FluidStack fluidStack) {
        Fluid fluid;
        if (fluidStack != null && FuelManager.bronzeEngineFuel.containsKey(fluid = fluidStack.getFluid())) {
            return FuelManager.bronzeEngineFuel.get(fluid).getPowerPerCycle();
        }
        return 0;
    }

    private static int determineBurnTime(@Nullable FluidStack fluidStack) {
        Fluid fluid;
        if (fluidStack != null && FuelManager.bronzeEngineFuel.containsKey(fluid = fluidStack.getFluid())) {
            return FuelManager.bronzeEngineFuel.get(fluid).getBurnDuration();
        }
        return 0;
    }

    @Override
    protected boolean isBurning() {
        return this.mayBurn() && this.burnTank.getFluidAmount() > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.burnTank.getCapacity() == 0) {
            return 0;
        }
        return this.burnTank.getFluidAmount() * i / this.burnTank.getCapacity();
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("shutdown")) {
            this.shutdown = nbt.func_74767_n("shutdown");
        }
        this.tankManager.read(nbt);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74757_a("shutdown", this.shutdown);
        this.tankManager.write(nbt);
        return nbt;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        data.writeBoolean(this.shutdown);
        this.tankManager.writeData(data);
        this.burnTank.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.shutdown = data.readBoolean();
        this.tankManager.readData(data);
        this.burnTank.readData(data);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerEngineBiogas(windowId, inv, this);
    }
}

