/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.blocks;

import forestry.core.blocks.BlockBase;
import forestry.core.blocks.IBlockTypeTesr;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.blocks.MachineProperties;
import forestry.core.blocks.MachinePropertiesTesr;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileMill;
import forestry.factory.features.FactoryTiles;
import forestry.modules.features.FeatureTileType;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public enum BlockTypeFactoryTesr implements IBlockTypeTesr
{
    BOTTLER(() -> FactoryTiles.BOTTLER, "bottler"),
    CARPENTER(() -> FactoryTiles.CARPENTER, "carpenter"),
    CENTRIFUGE(() -> FactoryTiles.CENTRIFUGE, "centrifuge"),
    FERMENTER(() -> FactoryTiles.FERMENTER, "fermenter"),
    MOISTENER(() -> FactoryTiles.MOISTENER, "moistener"),
    SQUEEZER(() -> FactoryTiles.SQUEEZER, "squeezer"),
    STILL(() -> FactoryTiles.STILL, "still"),
    RAINMAKER(() -> FactoryTiles.RAINMAKER, "rainmaker", "textures/block/rainmaker_");

    public static final BlockTypeFactoryTesr[] VALUES;
    private final IMachinePropertiesTesr<?> machineProperties;

    private <T extends TileBase> BlockTypeFactoryTesr(Supplier<FeatureTileType<? extends T>> teClass, String name) {
        VoxelShape nsBase = Block.func_208617_a((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)12.0);
        VoxelShape nsFront = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        VoxelShape nsBack = Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape ns = VoxelShapes.func_216384_a((VoxelShape)nsBase, (VoxelShape[])new VoxelShape[]{nsFront, nsBack});
        VoxelShape ewBase = Block.func_208617_a((double)4.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0);
        VoxelShape ewFront = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
        VoxelShape ewBack = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape ew = VoxelShapes.func_216384_a((VoxelShape)ewBase, (VoxelShape[])new VoxelShape[]{ewFront, ewBack});
        MachineProperties machineProperties = ((MachinePropertiesTesr.Builder)new MachinePropertiesTesr.Builder<T>(teClass, name).setParticleTexture(name + ".0").setShape((state, reader, pos, context) -> {
            Direction direction = (Direction)state.func_177229_b(BlockBase.FACING);
            return direction == Direction.NORTH || direction == Direction.SOUTH ? ns : ew;
        })).create();
        Proxies.render.setRenderDefaultMachine((MachinePropertiesTesr<? extends TileBase>)machineProperties, "textures/block/" + name + "_");
        this.machineProperties = machineProperties;
    }

    private <T extends TileMill> BlockTypeFactoryTesr(Supplier<FeatureTileType<? extends T>> teClass, String name, String renderMillTexture) {
        VoxelShape pedestal = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape column = Block.func_208617_a((double)5.0, (double)1.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
        VoxelShape extension = Block.func_208617_a((double)1.0, (double)8.0, (double)7.0, (double)15.0, (double)10.0, (double)9.0);
        MachineProperties machineProperties = ((MachinePropertiesTesr.Builder)new MachinePropertiesTesr.Builder<T>(teClass, name).setParticleTexture(name + ".0").setShape(() -> VoxelShapes.func_216384_a((VoxelShape)pedestal, (VoxelShape[])new VoxelShape[]{column, extension}))).create();
        Proxies.render.setRenderMill((MachinePropertiesTesr<? extends TileMill>)machineProperties, renderMillTexture);
        this.machineProperties = machineProperties;
    }

    @Override
    public IMachinePropertiesTesr<?> getMachineProperties() {
        return this.machineProperties;
    }

    public String func_176610_l() {
        return this.getMachineProperties().func_176610_l();
    }

    static {
        VALUES = BlockTypeFactoryTesr.values();
    }
}

