/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.api.recipes.RecipeManagers;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.SlotUtil;
import forestry.factory.tiles.TileCarpenter;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryCarpenter
extends InventoryAdapterTile<TileCarpenter> {
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_PRODUCT_COUNT = 1;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;

    public InventoryCarpenter(TileCarpenter carpenter) {
        super(carpenter, 30, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 11) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluid.map(f -> ((TileCarpenter)this.tile).getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        if (slotIndex == 9) {
            return RecipeManagers.carpenterManager.isBox(((TileCarpenter)this.tile).func_145831_w().func_199532_z(), itemStack);
        }
        if (this.canSlotAccept(11, itemStack) || this.canSlotAccept(9, itemStack)) {
            return false;
        }
        return SlotUtil.isSlotInRange(slotIndex, 12, 18);
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, Direction side) {
        return slotIndex == 10;
    }
}

