/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.api.recipes.RecipeManagers;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.SlotUtil;
import forestry.factory.tiles.TileFabricator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.Direction;

public class InventoryFabricator
extends InventoryAdapterTile<TileFabricator> {
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_INVENTORY_1 = 3;
    public static final short SLOT_INVENTORY_COUNT = 18;
    public static final short SLOT_COUNT = 21;

    public InventoryFabricator(TileFabricator fabricator) {
        super(fabricator, 21, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        RecipeManager recipeManager = ((TileFabricator)this.tile).func_145831_w().func_199532_z();
        if (slotIndex == 0) {
            return RecipeManagers.fabricatorSmeltingManager.findMatchingSmelting(recipeManager, itemStack) != null;
        }
        if (slotIndex == 1) {
            return RecipeManagers.fabricatorManager.isPlan(recipeManager, itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 3, 18)) {
            if (RecipeManagers.fabricatorManager.isPlan(recipeManager, itemStack)) {
                return false;
            }
            if (RecipeManagers.fabricatorSmeltingManager.findMatchingSmelting(recipeManager, itemStack) != null) {
                return false;
            }
        }
        return SlotUtil.isSlotInRange(slotIndex, 3, 18);
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack stack, Direction side) {
        return slotIndex == 2;
    }
}

