/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.api.fuels.FuelManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.FluidHelper;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.factory.tiles.TileFermenter;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryFermenter
extends InventoryAdapterTile<TileFermenter> {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_FUEL = 1;
    public static final short SLOT_CAN_OUTPUT = 2;
    public static final short SLOT_CAN_INPUT = 3;
    public static final short SLOT_INPUT = 4;

    public InventoryFermenter(TileFermenter fermenter) {
        super(fermenter, 5, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 0) {
            return RecipeManagers.fermenterManager.isResource(((TileFermenter)this.tile).func_145831_w().func_199532_z(), itemStack);
        }
        if (slotIndex == 4) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluid.map(f -> ((TileFermenter)this.tile).getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        if (slotIndex == 3) {
            return FluidHelper.isFillableContainerWithRoom(itemStack);
        }
        if (slotIndex == 1) {
            return FuelManager.fermenterFuel.containsKey(itemStack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, Direction side) {
        return slotIndex == 2;
    }
}

