/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.api.fuels.FuelManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.SlotUtil;
import forestry.factory.tiles.TileMoistener;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryMoistener
extends InventoryAdapterTile<TileMoistener> {
    public static final short SLOT_STASH_1 = 0;
    public static final short SLOT_STASH_COUNT = 6;
    public static final short SLOT_RESERVOIR_1 = 6;
    public static final short SLOT_RESERVOIR_COUNT = 3;
    public static final short SLOT_WORKING = 9;
    public static final short SLOT_PRODUCT = 10;
    public static final short SLOT_RESOURCE = 11;

    public InventoryMoistener(TileMoistener moistener) {
        super(moistener, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 11) {
            return RecipeManagers.moistenerManager.isResource(((TileMoistener)this.tile).func_145831_w().func_199532_z(), itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 6)) {
            return FuelManager.moistenerResource.containsKey(itemStack);
        }
        if (slotIndex == 10) {
            Optional fluidCap = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluidCap.map(f -> ((TileMoistener)this.tile).getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, Direction side) {
        if (slotIndex == 10) {
            return true;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 9)) {
            return !FuelManager.moistenerResource.containsKey(itemstack);
        }
        return false;
    }
}

