/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FabricatorRecipe
implements IFabricatorRecipe {
    private final ResourceLocation id;
    private final Ingredient plan;
    private final FluidStack molten;
    private final ShapedRecipe recipe;

    public FabricatorRecipe(ResourceLocation id, Ingredient plan, FluidStack molten, ShapedRecipe recipe) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)plan);
        Preconditions.checkNotNull((Object)molten);
        this.id = id;
        this.plan = plan;
        this.molten = molten;
        this.recipe = recipe;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public Ingredient getPlan() {
        return this.plan;
    }

    @Override
    public FluidStack getLiquid() {
        return this.molten;
    }

    @Override
    public ShapedRecipe getCraftingGridRecipe() {
        return this.recipe;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FabricatorRecipe> {
        public FabricatorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient plan = RecipeSerializers.deserialize(json.get("plan"));
            FluidStack molten = RecipeSerializers.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"molten"));
            ShapedRecipe internal = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, JSONUtils.func_152754_s((JsonObject)json, (String)"recipe"));
            return new FabricatorRecipe(recipeId, plan, molten, internal);
        }

        public FabricatorRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient plan = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidStack molten = buffer.readFluidStack();
            ShapedRecipe internal = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer);
            return new FabricatorRecipe(recipeId, plan, molten, internal);
        }

        public void toNetwork(PacketBuffer buffer, FabricatorRecipe recipe) {
            recipe.getPlan().func_199564_a(buffer);
            buffer.writeFluidStack(recipe.getLiquid());
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe.getCraftingGridRecipe());
        }
    }
}

