/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IFermenterManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IForestryRecipe;
import forestry.factory.recipes.AbstractCraftingProvider;
import forestry.factory.recipes.FermenterRecipe;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeManager
extends AbstractCraftingProvider<IFermenterRecipe>
implements IFermenterManager {
    public FermenterRecipeManager() {
        super(IFermenterRecipe.TYPE);
    }

    @Override
    public void addRecipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output, FluidStack liquid) {
        this.addRecipe(new FermenterRecipe(IForestryRecipe.anonymous(), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{resource}), fermentationValue, modifier, output.getFluid(), liquid));
    }

    @Override
    public void addRecipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output) {
        this.addRecipe(resource, fermentationValue, modifier, output, new FluidStack((Fluid)Fluids.field_204546_a, 1000));
    }

    @Override
    public void addRecipe(int fermentationValue, float modifier, FluidStack output, FluidStack liquid) {
        this.addRecipe(new FermenterRecipe(IForestryRecipe.anonymous(), fermentationValue, modifier, output.getFluid(), liquid));
    }

    @Override
    public void addRecipe(int fermentationValue, float modifier, FluidStack output) {
        this.addRecipe(fermentationValue, modifier, output, new FluidStack((Fluid)Fluids.field_204546_a, 1000));
    }

    @Override
    public boolean isResource(@Nullable RecipeManager recipeManager, ItemStack resource) {
        if (resource.func_190926_b()) {
            return false;
        }
        for (IFermenterRecipe recipe : this.getRecipes(recipeManager)) {
            if (!recipe.getResource().test(resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IFermenterRecipe findMatchingRecipe(@Nullable RecipeManager recipeManager, ItemStack res, FluidStack liqu) {
        if (res.func_190926_b()) {
            return null;
        }
        for (IFermenterRecipe recipe : this.getRecipes(recipeManager)) {
            if (!this.matches(recipe, res, liqu)) continue;
            return recipe;
        }
        return null;
    }

    public boolean matches(IFermenterRecipe recipe, ItemStack res, FluidStack liqu) {
        Ingredient resource = recipe.getResource();
        if (!resource.test(res)) {
            return false;
        }
        FluidStack fluid = recipe.getFluidResource();
        return liqu.isFluidEqual(fluid);
    }

    @Override
    public Set<ResourceLocation> getRecipeFluidInputs(@Nullable RecipeManager recipeManager) {
        return this.getRecipes(recipeManager).stream().map(recipe -> recipe.getFluidResource().getFluid().getRegistryName()).collect(Collectors.toSet());
    }

    @Override
    public Set<ResourceLocation> getRecipeFluidOutputs(@Nullable RecipeManager recipeManager) {
        return this.getRecipes(recipeManager).stream().map(recipe -> recipe.getOutput().getFluid().getRegistryName()).collect(Collectors.toSet());
    }
}

