/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class RecipeSerializers {
    static <E> void write(PacketBuffer buffer, NonNullList<E> list, BiConsumer<PacketBuffer, E> consumer) {
        buffer.func_150787_b(list.size());
        for (Object e : list) {
            consumer.accept(buffer, e);
        }
    }

    static <E> NonNullList<E> read(PacketBuffer buffer, Function<PacketBuffer, E> reader) {
        NonNullList list = NonNullList.func_191196_a();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            list.add(reader.apply(buffer));
        }
        return list;
    }

    public static FluidStack deserializeFluid(JsonObject object) {
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)((CompoundNBT)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)object)));
    }

    public static JsonObject serializeFluid(FluidStack fluid) {
        return (JsonObject)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)fluid.writeToNBT(new CompoundNBT()));
    }

    public static ItemStack item(JsonObject object) {
        return ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)object)));
    }

    public static JsonObject item(ItemStack stack) {
        return (JsonObject)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)stack.serializeNBT());
    }

    public static Ingredient deserialize(JsonElement resource) {
        if (resource.isJsonArray() && resource.getAsJsonArray().size() == 0) {
            return Ingredient.field_193370_a;
        }
        return Ingredient.func_199802_a((JsonElement)resource);
    }
}

