/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SqueezerContainerRecipe
implements ISqueezerContainerRecipe {
    private final ResourceLocation id;
    private final ItemStack emptyContainer;
    private final int processingTime;
    private final ItemStack remnants;
    private final float remnantsChance;

    public SqueezerContainerRecipe(ResourceLocation id, ItemStack emptyContainer, int processingTime, ItemStack remnants, float remnantsChance) {
        this.id = id;
        Preconditions.checkNotNull((Object)emptyContainer);
        Preconditions.checkArgument((!emptyContainer.func_190926_b() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)remnants);
        this.emptyContainer = emptyContainer;
        this.processingTime = processingTime;
        this.remnants = remnants;
        this.remnantsChance = remnantsChance;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return this.emptyContainer;
    }

    @Override
    public NonNullList<Ingredient> getResources() {
        return NonNullList.func_191196_a();
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public ItemStack getRemnants() {
        return this.remnants;
    }

    @Override
    public float getRemnantsChance() {
        return this.remnantsChance;
    }

    @Override
    public FluidStack getFluidOutput() {
        return FluidStack.EMPTY;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SqueezerContainerRecipe> {
        public SqueezerContainerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack emptyContainer = RecipeSerializers.item(JSONUtils.func_152754_s((JsonObject)json, (String)"container"));
            int processingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            ItemStack remnants = RecipeSerializers.item(JSONUtils.func_152754_s((JsonObject)json, (String)"remnants"));
            float remnantsChance = JSONUtils.func_151217_k((JsonObject)json, (String)"remnantsChance");
            return new SqueezerContainerRecipe(recipeId, emptyContainer, processingTime, remnants, remnantsChance);
        }

        public SqueezerContainerRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ItemStack emptyContainer = buffer.func_150791_c();
            int processingTime = buffer.func_150792_a();
            ItemStack remnants = buffer.func_150791_c();
            float remnantsChance = buffer.readFloat();
            return new SqueezerContainerRecipe(recipeId, emptyContainer, processingTime, remnants, remnantsChance);
        }

        public void toNetwork(PacketBuffer buffer, SqueezerContainerRecipe recipe) {
            buffer.func_150788_a(recipe.emptyContainer);
            buffer.func_150787_b(recipe.processingTime);
            buffer.func_150788_a(recipe.remnants);
            buffer.writeFloat(recipe.remnantsChance);
        }
    }
}

