/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.ISqueezerContainerManager;
import forestry.api.recipes.ISqueezerContainerRecipe;
import forestry.core.fluids.FluidHelper;
import forestry.factory.recipes.AbstractCraftingProvider;
import forestry.factory.recipes.SqueezerContainerRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;

public class SqueezerContainerRecipeManager
extends AbstractCraftingProvider<ISqueezerContainerRecipe>
implements ISqueezerContainerManager {
    public SqueezerContainerRecipeManager() {
        super(ISqueezerContainerRecipe.TYPE);
    }

    @Override
    public void addContainerRecipe(int timePerItem, ItemStack emptyContainer, ItemStack remnants, float chance) {
        this.addRecipe(new SqueezerContainerRecipe(IForestryRecipe.anonymous(), emptyContainer, timePerItem, remnants, chance));
    }

    @Override
    @Nullable
    public ISqueezerContainerRecipe findMatchingContainerRecipe(@Nullable RecipeManager recipeManager, ItemStack filledContainer) {
        if (!FluidHelper.isDrainableFilledContainer(filledContainer)) {
            return null;
        }
        for (ISqueezerContainerRecipe recipe : this.getRecipes(recipeManager)) {
            if (recipe.getEmptyContainer().func_77973_b() != filledContainer.func_77973_b()) continue;
            return recipe;
        }
        return null;
    }
}

