/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.ISqueezerManager;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.AbstractCraftingProvider;
import forestry.factory.recipes.SqueezerRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerRecipeManager
extends AbstractCraftingProvider<ISqueezerRecipe>
implements ISqueezerManager {
    public SqueezerRecipeManager() {
        super(ISqueezerRecipe.TYPE);
    }

    @Override
    public void addRecipe(int timePerItem, NonNullList<Ingredient> resources, FluidStack liquid, ItemStack remnants, int chance) {
        this.addRecipe(new SqueezerRecipe(IForestryRecipe.anonymous(), timePerItem, resources, liquid, remnants, (float)chance / 100.0f));
    }

    @Override
    public void addRecipe(int timePerItem, Ingredient resource, FluidStack liquid, ItemStack remnants, int chance) {
        NonNullList resourcesList = NonNullList.func_191196_a();
        resourcesList.add((Object)resource);
        this.addRecipe(timePerItem, (NonNullList<Ingredient>)resourcesList, liquid, remnants, chance);
    }

    @Override
    public void addRecipe(int timePerItem, NonNullList<Ingredient> resources, FluidStack liquid) {
        this.addRecipe(timePerItem, resources, liquid, ItemStack.field_190927_a, 0);
    }

    @Override
    public void addRecipe(int timePerItem, Ingredient resource, FluidStack liquid) {
        NonNullList resourcesList = NonNullList.func_191196_a();
        resourcesList.add((Object)resource);
        this.addRecipe(timePerItem, (NonNullList<Ingredient>)resourcesList, liquid);
    }

    @Override
    @Nullable
    public ISqueezerRecipe findMatchingRecipe(@Nullable RecipeManager recipeManager, NonNullList<ItemStack> items) {
        for (ISqueezerRecipe recipe : this.getRecipes(recipeManager)) {
            if (ItemStackUtil.createConsume(recipe.getResources(), items.size(), arg_0 -> items.get(arg_0), false).length <= 0) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean canUse(@Nullable RecipeManager recipeManager, ItemStack itemStack) {
        for (ISqueezerRecipe recipe : this.getRecipes(recipeManager)) {
            for (Ingredient recipeInput : recipe.getResources()) {
                if (!recipeInput.test(itemStack)) continue;
                return true;
            }
        }
        return false;
    }
}

