/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IStillRecipe;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class StillRecipe
implements IStillRecipe {
    private final ResourceLocation id;
    private final int timePerUnit;
    private final FluidStack input;
    private final FluidStack output;

    public StillRecipe(ResourceLocation id, int timePerUnit, FluidStack input, FluidStack output) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)input, (Object)"Still recipes need an input. Input was null.");
        Preconditions.checkNotNull((Object)output, (Object)"Still recipes need an output. Output was null.");
        this.id = id;
        this.timePerUnit = timePerUnit;
        this.input = input;
        this.output = output;
    }

    @Override
    public int getCyclesPerUnit() {
        return this.timePerUnit;
    }

    @Override
    public FluidStack getInput() {
        return this.input;
    }

    @Override
    public FluidStack getOutput() {
        return this.output;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<StillRecipe> {
        public StillRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int timePerUnit = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            FluidStack input = RecipeSerializers.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            FluidStack output = RecipeSerializers.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            return new StillRecipe(recipeId, timePerUnit, input, output);
        }

        public StillRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int timePerUnit = buffer.func_150792_a();
            FluidStack input = FluidStack.readFromPacket((PacketBuffer)buffer);
            FluidStack output = FluidStack.readFromPacket((PacketBuffer)buffer);
            return new StillRecipe(recipeId, timePerUnit, input, output);
        }

        public void toNetwork(PacketBuffer buffer, StillRecipe recipe) {
            buffer.func_150787_b(recipe.timePerUnit);
            recipe.input.writeToPacket(buffer);
            recipe.output.writeToPacket(buffer);
        }
    }
}

