/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.IStillManager;
import forestry.api.recipes.IStillRecipe;
import forestry.factory.recipes.AbstractCraftingProvider;
import forestry.factory.recipes.StillRecipe;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class StillRecipeManager
extends AbstractCraftingProvider<IStillRecipe>
implements IStillManager {
    public StillRecipeManager() {
        super(IStillRecipe.TYPE);
    }

    @Override
    public void addRecipe(int timePerUnit, FluidStack input, FluidStack output) {
        StillRecipe recipe = new StillRecipe(IForestryRecipe.anonymous(), timePerUnit, input, output);
        this.addRecipe(recipe);
    }

    @Override
    @Nullable
    public IStillRecipe findMatchingRecipe(@Nullable RecipeManager recipeManager, @Nullable FluidStack item) {
        if (item == null) {
            return null;
        }
        for (IStillRecipe recipe : this.getRecipes(recipeManager)) {
            if (!this.matches(recipe, item)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean matches(@Nullable IStillRecipe recipe, @Nullable FluidStack item) {
        if (recipe == null || item == null) {
            return false;
        }
        return item.containsFluid(recipe.getInput());
    }

    @Override
    public Set<ResourceLocation> getRecipeFluidInputs(@Nullable RecipeManager recipeManager) {
        return this.getRecipes(recipeManager).stream().map(recipe -> recipe.getInput().getFluid().getRegistryName()).collect(Collectors.toSet());
    }

    @Override
    public Set<ResourceLocation> getRecipeFluidOutputs(@Nullable RecipeManager recipeManager) {
        return this.getRecipes(recipeManager).stream().map(recipe -> recipe.getOutput().getFluid().getRegistryName()).collect(Collectors.toSet());
    }
}

