/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei;

import forestry.core.features.FluidsItems;
import forestry.core.gui.GuiForestry;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeCategoryUid;
import forestry.core.utils.ClientUtils;
import forestry.core.utils.JeiUtil;
import forestry.factory.ModuleFactory;
import forestry.factory.blocks.BlockTypeFactoryPlain;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.factory.gui.GuiBottler;
import forestry.factory.gui.GuiCarpenter;
import forestry.factory.gui.GuiCentrifuge;
import forestry.factory.gui.GuiFabricator;
import forestry.factory.gui.GuiFermenter;
import forestry.factory.gui.GuiMoistener;
import forestry.factory.gui.GuiSqueezer;
import forestry.factory.gui.GuiStill;
import forestry.factory.recipes.jei.bottler.BottlerRecipeCategory;
import forestry.factory.recipes.jei.bottler.BottlerRecipeMaker;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeCategory;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeMaker;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeTransferHandler;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeCategory;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeMaker;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeCategory;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeMaker;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeTransferHandler;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeCategory;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeMaker;
import forestry.factory.recipes.jei.moistener.MoistenerRecipeCategory;
import forestry.factory.recipes.jei.moistener.MoistenerRecipeMaker;
import forestry.factory.recipes.jei.rainmaker.RainmakerRecipeCategory;
import forestry.factory.recipes.jei.rainmaker.RainmakerRecipeMaker;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeCategory;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeMaker;
import forestry.factory.recipes.jei.still.StillRecipeCategory;
import forestry.factory.recipes.jei.still.StillRecipeMaker;
import forestry.modules.ModuleHelper;
import forestry.modules.features.FeatureBlock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

@OnlyIn(value=Dist.CLIENT)
@JeiPlugin
public class FactoryJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("forestry", "factory");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!ModuleHelper.isEnabled("factory")) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        ArrayList<ForestryRecipeCategory> categories = new ArrayList<ForestryRecipeCategory>();
        if (ModuleFactory.machineEnabled("bottler")) {
            categories.add(new BottlerRecipeCategory(guiHelper));
        }
        if (ModuleFactory.machineEnabled("carpenter")) {
            categories.add(new CarpenterRecipeCategory(guiHelper));
        }
        if (ModuleFactory.machineEnabled("centrifuge")) {
            categories.add(new CentrifugeRecipeCategory(guiHelper));
        }
        if (ModuleFactory.machineEnabled("fabricator")) {
            RecipeManager recipeManager = ClientUtils.getRecipeManager();
            categories.add(new FabricatorRecipeCategory(guiHelper, recipeManager));
        }
        if (ModuleFactory.machineEnabled("fermenter")) {
            categories.add(new FermenterRecipeCategory(guiHelper));
        }
        if (ModuleFactory.machineEnabled("moistener")) {
            categories.add(new MoistenerRecipeCategory(guiHelper));
        }
        if (ModuleFactory.machineEnabled("rainmaker")) {
            categories.add(new RainmakerRecipeCategory(guiHelper));
        }
        if (ModuleFactory.machineEnabled("squeezer")) {
            categories.add(new SqueezerRecipeCategory(guiHelper));
        }
        if (ModuleFactory.machineEnabled("still")) {
            categories.add(new StillRecipeCategory(guiHelper));
        }
        registry.addRecipeCategories(categories.toArray(new IRecipeCategory[0]));
    }

    public void registerRecipes(IRecipeRegistration registry) {
        if (!ModuleHelper.isEnabled("factory")) {
            return;
        }
        RecipeManager recipeManager = ClientUtils.getRecipeManager();
        if (ModuleFactory.machineEnabled("bottler")) {
            registry.addRecipes(BottlerRecipeMaker.getBottlerRecipes(registry.getIngredientManager()), ForestryRecipeCategoryUid.BOTTLER);
        }
        if (ModuleFactory.machineEnabled("carpenter")) {
            registry.addRecipes(CarpenterRecipeMaker.getCarpenterRecipes(recipeManager), ForestryRecipeCategoryUid.CARPENTER);
        }
        if (ModuleFactory.machineEnabled("centrifuge")) {
            registry.addRecipes(CentrifugeRecipeMaker.getCentrifugeRecipe(recipeManager), ForestryRecipeCategoryUid.CENTRIFUGE);
        }
        if (ModuleFactory.machineEnabled("fabricator")) {
            registry.addRecipes(FabricatorRecipeMaker.getFabricatorRecipes(recipeManager), ForestryRecipeCategoryUid.FABRICATOR);
        }
        if (ModuleFactory.machineEnabled("fermenter")) {
            registry.addRecipes(FermenterRecipeMaker.getFermenterRecipes(recipeManager, registry.getJeiHelpers().getStackHelper()), ForestryRecipeCategoryUid.FERMENTER);
        }
        if (ModuleFactory.machineEnabled("moistener")) {
            registry.addRecipes(MoistenerRecipeMaker.getMoistenerRecipes(recipeManager), ForestryRecipeCategoryUid.MOISTENER);
        }
        if (ModuleFactory.machineEnabled("rainmaker")) {
            registry.addRecipes(RainmakerRecipeMaker.getRecipes(), ForestryRecipeCategoryUid.RAINMAKER);
        }
        if (ModuleFactory.machineEnabled("squeezer")) {
            registry.addRecipes(SqueezerRecipeMaker.getSqueezerRecipes(recipeManager), ForestryRecipeCategoryUid.SQUEEZER);
        }
        if (ModuleFactory.machineEnabled("still")) {
            registry.addRecipes(StillRecipeMaker.getStillRecipes(recipeManager), ForestryRecipeCategoryUid.STILL);
        }
        if (ModuleFactory.machineEnabled("raintank")) {
            JeiUtil.addDescription(registry, new Block[]{((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.RAINTANK)).getBlock()});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        if (ModuleFactory.machineEnabled("carpenter")) {
            registry.addRecipeTransferHandler((IRecipeTransferHandler)new CarpenterRecipeTransferHandler(), ForestryRecipeCategoryUid.CARPENTER);
        }
        if (ModuleFactory.machineEnabled("fabricator")) {
            registry.addRecipeTransferHandler((IRecipeTransferHandler)new FabricatorRecipeTransferHandler(), ForestryRecipeCategoryUid.FABRICATOR);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        if (ModuleFactory.machineEnabled("bottler")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.BOTTLER)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.BOTTLER});
        }
        if (ModuleFactory.machineEnabled("carpenter")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CARPENTER)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.CARPENTER});
        }
        if (ModuleFactory.machineEnabled("centrifuge")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CENTRIFUGE)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.CENTRIFUGE});
        }
        if (ModuleFactory.machineEnabled("fabricator")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.FABRICATOR)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.FABRICATOR});
        }
        if (ModuleFactory.machineEnabled("fermenter")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.FERMENTER)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.FERMENTER});
        }
        if (ModuleFactory.machineEnabled("moistener")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.MOISTENER)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.MOISTENER});
        }
        if (ModuleFactory.machineEnabled("rainmaker")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.RAINTANK)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.RAINMAKER});
        }
        if (ModuleFactory.machineEnabled("squeezer")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.SQUEEZER)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.SQUEEZER});
        }
        if (ModuleFactory.machineEnabled("still")) {
            registry.addRecipeCatalyst((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.STILL)).block()), new ResourceLocation[]{ForestryRecipeCategoryUid.STILL});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addGenericGuiContainerHandler(GuiForestry.class, new ForestryAdvancedGuiHandler());
        if (ModuleFactory.machineEnabled("bottler")) {
            registry.addRecipeClickArea(GuiBottler.class, 107, 33, 26, 22, new ResourceLocation[]{ForestryRecipeCategoryUid.BOTTLER});
            registry.addRecipeClickArea(GuiBottler.class, 45, 33, 26, 22, new ResourceLocation[]{ForestryRecipeCategoryUid.BOTTLER});
        }
        if (ModuleFactory.machineEnabled("carpenter")) {
            registry.addRecipeClickArea(GuiCarpenter.class, 98, 48, 21, 26, new ResourceLocation[]{ForestryRecipeCategoryUid.CARPENTER});
        }
        if (ModuleFactory.machineEnabled("centrifuge")) {
            registry.addRecipeClickArea(GuiCentrifuge.class, 38, 22, 38, 14, new ResourceLocation[]{ForestryRecipeCategoryUid.CENTRIFUGE});
            registry.addRecipeClickArea(GuiCentrifuge.class, 38, 54, 38, 14, new ResourceLocation[]{ForestryRecipeCategoryUid.CENTRIFUGE});
        }
        if (ModuleFactory.machineEnabled("fabricator")) {
            registry.addRecipeClickArea(GuiFabricator.class, 121, 53, 18, 18, new ResourceLocation[]{ForestryRecipeCategoryUid.FABRICATOR});
        }
        if (ModuleFactory.machineEnabled("fermenter")) {
            registry.addRecipeClickArea(GuiFermenter.class, 72, 40, 32, 18, new ResourceLocation[]{ForestryRecipeCategoryUid.FERMENTER});
        }
        if (ModuleFactory.machineEnabled("moistener")) {
            registry.addRecipeClickArea(GuiMoistener.class, 123, 35, 19, 21, new ResourceLocation[]{ForestryRecipeCategoryUid.MOISTENER});
        }
        if (ModuleFactory.machineEnabled("squeezer")) {
            registry.addRecipeClickArea(GuiSqueezer.class, 76, 41, 43, 16, new ResourceLocation[]{ForestryRecipeCategoryUid.SQUEEZER});
        }
        if (ModuleFactory.machineEnabled("still")) {
            registry.addRecipeClickArea(GuiStill.class, 73, 17, 33, 57, new ResourceLocation[]{ForestryRecipeCategoryUid.STILL});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        ISubtypeInterpreter subtypeInterpreter = itemStack -> {
            LazyOptional fluidHandler = itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            return fluidHandler.map(handler -> handler.getFluidInTank(0)).map(fluid -> fluid.getFluid().getRegistryName().toString()).orElse("");
        };
        for (Item container : FluidsItems.CONTAINERS.itemArray()) {
            subtypeRegistry.registerSubtypeInterpreter(container, subtypeInterpreter);
        }
    }

    static class ForestryAdvancedGuiHandler<T extends Container>
    implements IGuiContainerHandler<GuiForestry<?>> {
        ForestryAdvancedGuiHandler() {
        }

        public List<Rectangle2d> getGuiExtraAreas(GuiForestry<?> guiContainer) {
            return guiContainer.getExtraGuiAreas();
        }

        @Nullable
        public Object getIngredientUnderMouse(GuiForestry<?> guiContainer, double mouseX, double mouseY) {
            return guiContainer.getFluidStackAtPosition(mouseX, mouseY);
        }
    }
}

