/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.bottler;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeCategoryUid;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.factory.recipes.jei.bottler.BottlerRecipeWrapper;
import forestry.modules.features.FeatureBlock;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BottlerRecipeCategory
extends ForestryRecipeCategory<BottlerRecipeWrapper> {
    private static final int inputFull = 0;
    private static final int outputEmpty = 1;
    private static final int inputEmpty = 2;
    private static final int outputFull = 3;
    private static final int tankIndex = 0;
    private static final ResourceLocation guiTexture = new ResourceLocation("forestry", "textures/gui/bottler.png");
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable tank;
    private final IDrawable arrowDown;
    private final IDrawable tankOverlay;

    public BottlerRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createBlankDrawable(62, 60), "block.forestry.bottler");
        this.slot = guiHelper.getSlotDrawable();
        this.tank = guiHelper.createDrawable(guiTexture, 79, 13, 18, 60);
        this.arrowDown = guiHelper.createDrawable(guiTexture, 20, 25, 12, 8);
        this.tankOverlay = guiHelper.createDrawable(guiTexture, 176, 0, 16, 58);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.BOTTLER)).block()));
    }

    public ResourceLocation getUid() {
        return ForestryRecipeCategoryUid.BOTTLER;
    }

    public Class<? extends BottlerRecipeWrapper> getRecipeClass() {
        return BottlerRecipeWrapper.class;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, BottlerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (recipeWrapper.fillRecipe) {
            guiItemStacks.init(2, true, 44, 0);
            guiItemStacks.init(3, false, 44, 42);
            guiFluidStacks.init(0, true, 23, 1, 16, 58, 10000, false, this.tankOverlay);
        } else {
            guiItemStacks.init(0, true, 0, 0);
            guiItemStacks.init(1, false, 0, 42);
            guiFluidStacks.init(0, false, 23, 1, 16, 58, 10000, false, this.tankOverlay);
        }
        guiItemStacks.set(ingredients);
        guiFluidStacks.set(ingredients);
    }

    public void draw(BottlerRecipeWrapper recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.slot.draw(matrixStack, 0, 0);
        this.arrowDown.draw(matrixStack, 3, 26);
        this.slot.draw(matrixStack, 0, 42);
        this.tank.draw(matrixStack, 22, 0);
        this.slot.draw(matrixStack, 44, 0);
        this.arrowDown.draw(matrixStack, 47, 26);
        this.slot.draw(matrixStack, 44, 42);
    }
}

