/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.bottler;

import forestry.factory.recipes.jei.bottler.BottlerRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class BottlerRecipeMaker {
    public static List<BottlerRecipeWrapper> getBottlerRecipes(IIngredientManager ingredientRegistry) {
        ArrayList<BottlerRecipeWrapper> recipes = new ArrayList<BottlerRecipeWrapper>();
        for (ItemStack stack : ingredientRegistry.getAllIngredients(VanillaTypes.ITEM)) {
            LazyOptional lazyDrainFluidHandler = stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (!lazyDrainFluidHandler.isPresent()) continue;
            BottlerRecipeMaker.addDrainRecipes(recipes, (IFluidHandlerItem)lazyDrainFluidHandler.orElse(null), stack);
            BottlerRecipeMaker.addFillRecipes(recipes, stack);
        }
        return recipes;
    }

    private static void addDrainRecipes(List<BottlerRecipeWrapper> recipes, IFluidHandlerItem fluidHandler, ItemStack stack) {
        if (Items.field_151133_ar.equals(stack.func_77973_b())) {
            return;
        }
        FluidStack drainedFluid = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (drainedFluid.isEmpty()) {
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                IFluidHandlerItem currentFluidHandler = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
                int simulateFill = currentFluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
                if (simulateFill <= 0) continue;
                currentFluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
                BottlerRecipeMaker.addDrainRecipe(recipes, currentFluidHandler, currentFluidHandler.getContainer().func_77946_l());
            }
        } else {
            BottlerRecipeMaker.addDrainRecipe(recipes, fluidHandler, stack);
        }
    }

    private static void addDrainRecipe(List<BottlerRecipeWrapper> recipes, IFluidHandlerItem fluidHandler, ItemStack stack) {
        FluidStack drainedFluid = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        if (!drainedFluid.isEmpty() && drainedFluid.getAmount() > 0) {
            ItemStack drained = fluidHandler.getContainer();
            if (drained.func_77973_b() == Items.field_190931_a) {
                drained = null;
            }
            recipes.add(new BottlerRecipeWrapper(stack, drainedFluid, drained, false));
        }
    }

    private static void addFillRecipes(List<BottlerRecipeWrapper> recipes, ItemStack stack) {
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            IFluidHandlerItem currentFluidHandler = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            int simulateFill = currentFluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
            if (simulateFill <= 0) continue;
            FluidStack filledFluid = new FluidStack(fluid, simulateFill);
            currentFluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
            ItemStack filled = currentFluidHandler.getContainer();
            if (filled.func_77973_b() == Items.field_190931_a) {
                filled = null;
            }
            recipes.add(new BottlerRecipeWrapper(stack, filledFluid, filled, true));
        }
    }
}

