/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.carpenter;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeCategoryUid;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeWrapper;
import forestry.modules.features.FeatureBlock;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class CarpenterRecipeCategory
extends ForestryRecipeCategory<CarpenterRecipeWrapper> {
    private static final int boxSlot = 0;
    private static final int craftOutputSlot = 1;
    private static final int craftInputSlot = 2;
    private static final int inputTank = 0;
    private static final ResourceLocation guiTexture = new ResourceLocation("forestry", "textures/gui/carpenter.png");
    private final ICraftingGridHelper craftingGridHelper;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;
    private final IDrawable icon;

    public CarpenterRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 9, 16, 158, 61), "block.forestry.carpenter");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(2);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(guiTexture, 176, 59, 4, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.tankOverlay = guiHelper.createDrawable(guiTexture, 176, 0, 16, 58);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CARPENTER)).block()));
    }

    public ResourceLocation getUid() {
        return ForestryRecipeCategoryUid.CARPENTER;
    }

    public Class<? extends CarpenterRecipeWrapper> getRecipeClass() {
        return CarpenterRecipeWrapper.class;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, CarpenterRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 73, 3);
        guiItemStacks.init(1, false, 70, 34);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 2 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, 3 + y * 18);
            }
        }
        guiFluidStacks.init(0, true, 141, 1, 16, 58, 10000, false, this.tankOverlay);
        List craftingInputs = ingredients.getInputs(VanillaTypes.ITEM);
        ICarpenterRecipe recipe = (ICarpenterRecipe)recipeWrapper.getRecipe();
        Ingredient box = recipe.getBox();
        if (!box.func_203189_d()) {
            guiItemStacks.set(0, (List)craftingInputs.get(craftingInputs.size() - 1));
        }
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.set(1, (List)outputs.get(0));
        ICraftingRecipe craftingGridRecipe = recipe.getCraftingGridRecipe();
        int width = 3;
        int height = 3;
        if (craftingGridRecipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)craftingGridRecipe;
            width = shapedRecipe.getRecipeWidth();
            height = shapedRecipe.getRecipeHeight();
        }
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, craftingInputs.subList(0, Math.min(9, craftingInputs.size() - 1)), width, height);
        List fluidInputs = ingredients.getInputs(VanillaTypes.FLUID);
        if (!fluidInputs.isEmpty()) {
            guiFluidStacks.set(0, (List)fluidInputs.get(0));
        }
    }

    public void draw(CarpenterRecipeWrapper recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 89, 34);
    }
}

