/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fabricator;

import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeCategoryUid;
import forestry.factory.blocks.BlockTypeFactoryPlain;
import forestry.factory.features.FactoryBlocks;
import forestry.factory.recipes.jei.fabricator.FabricatorRecipeWrapper;
import forestry.modules.features.FeatureBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;

public class FabricatorRecipeCategory
extends ForestryRecipeCategory<FabricatorRecipeWrapper> {
    private static final int planSlot = 0;
    private static final int smeltingInputSlot = 1;
    private static final int craftOutputSlot = 2;
    private static final int craftInputSlot = 3;
    private static final int inputTank = 0;
    private static final ResourceLocation guiTexture = new ResourceLocation("forestry", "textures/gui/fabricator.png");
    private final ICraftingGridHelper craftingGridHelper;
    private final IDrawable icon;
    private final RecipeManager manager;

    public FabricatorRecipeCategory(IGuiHelper guiHelper, RecipeManager manager) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 20, 16, 136, 54), "block.forestry.fabricator");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(3);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.FABRICATOR)).block()));
        this.manager = manager;
    }

    private static Map<Fluid, List<IFabricatorSmeltingRecipe>> getSmeltingInputs(RecipeManager manager) {
        HashMap<Fluid, List<IFabricatorSmeltingRecipe>> smeltingInputs = new HashMap<Fluid, List<IFabricatorSmeltingRecipe>>();
        for (IFabricatorSmeltingRecipe smelting : RecipeManagers.fabricatorSmeltingManager.getRecipes(manager)) {
            Fluid fluid = smelting.getProduct().getFluid();
            if (!smeltingInputs.containsKey(fluid)) {
                smeltingInputs.put(fluid, new ArrayList());
            }
            ((List)smeltingInputs.get(fluid)).add(smelting);
        }
        return smeltingInputs;
    }

    public ResourceLocation getUid() {
        return ForestryRecipeCategoryUid.FABRICATOR;
    }

    public Class<? extends FabricatorRecipeWrapper> getRecipeClass() {
        return FabricatorRecipeWrapper.class;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, FabricatorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 118, 0);
        guiItemStacks.init(1, true, 5, 4);
        guiItemStacks.init(2, false, 118, 36);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 3 + x + y * 3;
                guiItemStacks.init(index, true, 46 + x * 18, y * 18);
            }
        }
        guiFluidStacks.init(0, true, 6, 32, 16, 16, 2000, false, null);
        IFabricatorRecipe recipe = (IFabricatorRecipe)recipeWrapper.getRecipe();
        Ingredient plan = recipe.getPlan();
        if (!plan.func_203189_d()) {
            guiItemStacks.set(0, plan.func_193365_a()[0]);
        }
        ArrayList smeltingInput = new ArrayList();
        Fluid recipeFluid = recipe.getLiquid().getFluid();
        for (IFabricatorSmeltingRecipe s : FabricatorRecipeCategory.getSmeltingInputs(this.manager).get(recipeFluid)) {
            Optional<ItemStack> itemStack = Arrays.stream(s.getResource().func_193365_a()).findFirst();
            itemStack.ifPresent(smeltingInput::add);
        }
        if (!smeltingInput.isEmpty()) {
            guiItemStacks.set(1, smeltingInput);
        }
        List itemOutputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.set(2, (List)itemOutputs.get(0));
        List itemStackInputs = ingredients.getInputs(VanillaTypes.ITEM);
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, itemStackInputs, recipe.getCraftingGridRecipe().func_192403_f(), recipe.getCraftingGridRecipe().func_192404_g());
        List fluidInputs = ingredients.getInputs(VanillaTypes.FLUID);
        if (!fluidInputs.isEmpty()) {
            guiFluidStacks.set(0, (List)fluidInputs.get(0));
        }
    }
}

