/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.moistener;

import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.core.recipes.jei.ForestryRecipeWrapper;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class MoistenerRecipeWrapper
extends ForestryRecipeWrapper<IMoistenerRecipe> {
    private final MoistenerFuel fuel;

    public MoistenerRecipeWrapper(IMoistenerRecipe recipe, MoistenerFuel fuel) {
        super(recipe);
        this.fuel = fuel;
    }

    public void setIngredients(IIngredients ingredients) {
        IMoistenerRecipe recipe = (IMoistenerRecipe)this.getRecipe();
        ArrayList<Ingredient> itemIngredients = new ArrayList<Ingredient>();
        itemIngredients.add(recipe.getResource());
        itemIngredients.add(this.fuel.getResource());
        ingredients.setInputIngredients(itemIngredients);
        ArrayList<ItemStack> itemStackOutputs = new ArrayList<ItemStack>();
        itemStackOutputs.add(recipe.getProduct());
        ItemStack fuelProduct = this.fuel.getProduct();
        itemStackOutputs.add(fuelProduct);
        ingredients.setOutputs(VanillaTypes.ITEM, itemStackOutputs);
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)Fluids.field_204546_a, recipe.getTimePerItem() / 4));
    }

    public MoistenerFuel getFuel() {
        return this.fuel;
    }
}

