/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.rainmaker;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.fuels.RainSubstrate;
import java.awt.Color;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RainmakerRecipeWrapper
implements IRecipeCategoryExtension {
    private final RainSubstrate substrate;

    public RainmakerRecipeWrapper(RainSubstrate substrate) {
        this.substrate = substrate;
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, Collections.singletonList(this.substrate.getItem()));
    }

    public void drawInfo(int recipeWidth, int recipeHeight, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)this.getEffectString(), 24.0f, 0.0f, Color.darkGray.getRGB());
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("for.jei.rainmaker.speed", new Object[]{Float.valueOf(this.substrate.getSpeed())}), 24.0f, 10.0f, Color.gray.getRGB());
        if (!this.substrate.isReverse()) {
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("for.jei.rainmaker.duration", new Object[]{this.substrate.getDuration()}), 24.0f, 20.0f, Color.gray.getRGB());
        }
    }

    private TranslationTextComponent getEffectString() {
        if (this.substrate.isReverse()) {
            return new TranslationTextComponent("for.jei.rainmaker.stops.rain");
        }
        return new TranslationTextComponent("for.jei.rainmaker.causes.rain");
    }
}

