/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.InventoryGhostCrafting;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerCarpenter;
import forestry.factory.inventory.InventoryCarpenter;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileCarpenter
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IItemStackDisplay {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 2040;
    private static final int ENERGY_PER_RECIPE_TIME = 204;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final InventoryAdapterTile craftingInventory;
    private final CraftResultInventory craftPreviewInventory;
    @Nullable
    private ICarpenterRecipe currentRecipe;

    private ItemStack getBoxStack() {
        return this.getInternalInventory().func_70301_a(9);
    }

    public TileCarpenter() {
        super(FactoryTiles.CARPENTER.tileType(), 1100, 4000);
        this.setEnergyPerWorkCycle(2040);
        this.resourceTank = new FilteredTank(10000).setFilters(() -> RecipeManagers.carpenterManager.getRecipeFluids(this.func_145831_w().func_199532_z()));
        this.craftingInventory = new InventoryGhostCrafting<TileCarpenter>(this, 10);
        this.craftPreviewInventory = new CraftResultInventory();
        this.setInternalInventory(new InventoryCarpenter(this));
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.tankManager.write(compoundNBT);
        this.craftingInventory.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.tankManager.read(compoundNBT);
        this.craftingInventory.read(compoundNBT);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    public void checkRecipe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!RecipeManagers.carpenterManager.matches(this.currentRecipe, this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory, this.field_145850_b)) {
            Optional<ICarpenterRecipe> optional = RecipeManagers.carpenterManager.findMatchingRecipe(this.field_145850_b.func_199532_z(), this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory, this.field_145850_b);
            this.currentRecipe = optional.orElse(null);
            if (optional.isPresent()) {
                int recipeTime = this.currentRecipe.getPackagingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 204);
                ItemStack craftingResult = this.currentRecipe.getResult();
                this.craftPreviewInventory.func_70299_a(0, craftingResult);
            } else {
                this.craftPreviewInventory.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 11);
        }
    }

    @Override
    public boolean workCycle() {
        if (!this.removeLiquidResources(true)) {
            return false;
        }
        if (!this.removeItemResources(true)) {
            return false;
        }
        if (this.currentRecipe != null) {
            ItemStack pendingProduct = this.currentRecipe.getResult();
            InventoryUtil.tryAddStack((IInventory)this, pendingProduct, 10, 1, true);
        }
        return true;
    }

    private boolean removeLiquidResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        FluidStack fluid = this.currentRecipe.getFluidResource();
        if (fluid != null && !fluid.isEmpty()) {
            FluidStack drained = this.resourceTank.drainInternal(fluid, IFluidHandler.FluidAction.SIMULATE);
            if (!fluid.isFluidStackIdentical(drained)) {
                return false;
            }
            if (doRemove) {
                this.resourceTank.drainInternal(fluid, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return true;
    }

    private boolean removeItemResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        if (!this.currentRecipe.getBox().func_203189_d()) {
            ItemStack box = this.func_70301_a(9);
            if (box.func_190926_b()) {
                return false;
            }
            if (doRemove) {
                this.func_70298_a(9, 1);
            }
        }
        InventoryMapper inventory = new InventoryMapper((IInventory)this.getInternalInventory(), 12, 18);
        return InventoryUtil.consumeIngredients(inventory, (NonNullList<Ingredient>)this.currentRecipe.getCraftingGridRecipe().func_192400_c(), null, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        if (this.updateOnInterval(20)) {
            this.checkRecipe();
        }
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasLiquidResources = true;
        boolean hasItemResources = true;
        boolean canAdd = true;
        if (hasRecipe) {
            hasLiquidResources = this.removeLiquidResources(false);
            hasItemResources = this.removeItemResources(false);
            ItemStack pendingProduct = this.currentRecipe.getResult();
            canAdd = InventoryUtil.tryAddStack((IInventory)this, pendingProduct, 10, 1, true, false);
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasLiquidResources, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasItemResources, EnumErrorCode.NO_RESOURCE_INVENTORY);
        errorLogic.setCondition(!canAdd, EnumErrorCode.NO_SPACE_INVENTORY);
        return hasRecipe && hasItemResources && hasLiquidResources && canAdd;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    public IInventory getCraftingInventory() {
        return this.craftingInventory;
    }

    public IInventory getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.func_70299_a(0, itemStack);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerCarpenter(windowId, player.field_71071_by, this);
    }
}

