/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.InventoryGhostCrafting;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.items.definitions.ICraftingPlan;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerFabricator;
import forestry.factory.inventory.InventoryFabricator;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileFabricator
extends TilePowered
implements ISlotPickupWatcher,
ILiquidTankTile,
ISidedInventory {
    private static final int MAX_HEAT = 5000;
    private final InventoryAdapterTile craftingInventory;
    private final TankManager tankManager;
    private final FilteredTank moltenTank;
    private int heat = 0;
    private int meltingPoint = 0;

    public TileFabricator() {
        super(FactoryTiles.FABRICATOR.tileType(), 1100, 3300);
        this.setEnergyPerWorkCycle(200);
        this.craftingInventory = new InventoryGhostCrafting<TileFabricator>(this, 9);
        this.setInternalInventory(new InventoryFabricator(this));
        this.moltenTank = new FilteredTank(8000, false, true).setFilters(() -> RecipeManagers.fabricatorSmeltingManager.getRecipeFluids(this.func_145831_w().func_199532_z()));
        this.tankManager = new TankManager(this, this.moltenTank);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("Heat", this.heat);
        this.tankManager.write(compound);
        this.craftingInventory.write(compound);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.heat = compound.func_74762_e("Heat");
        this.tankManager.read(compound);
        this.craftingInventory.read(compound);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.moltenTank.isFull()) {
            this.trySmelting();
        }
        if (!this.moltenTank.isEmpty() && this.heat < this.getMeltingPoint() - 100) {
            this.moltenTank.drain(5, IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    private void trySmelting() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack smeltResource = inventory.func_70301_a(0);
        if (smeltResource.func_190926_b()) {
            return;
        }
        IFabricatorSmeltingRecipe smelt = RecipeManagers.fabricatorSmeltingManager.findMatchingSmelting(this.func_145831_w().func_199532_z(), smeltResource);
        if (smelt == null || smelt.getMeltingPoint() > this.heat) {
            return;
        }
        FluidStack smeltFluid = smelt.getProduct();
        if (this.moltenTank.fillInternal(smeltFluid, IFluidHandler.FluidAction.SIMULATE) == smeltFluid.getAmount()) {
            this.func_70298_a(0, 1);
            this.moltenTank.fillInternal(smeltFluid, IFluidHandler.FluidAction.EXECUTE);
            this.meltingPoint = smelt.getMeltingPoint();
        }
    }

    @Override
    public boolean workCycle() {
        this.heat += 100;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        this.craftResult();
        return true;
    }

    private Optional<IFabricatorRecipe> getRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack plan = inventory.func_70301_a(1);
        FluidStack liquid = this.moltenTank.getFluid();
        Optional<IFabricatorRecipe> recipePair = RecipeManagers.fabricatorManager.findMatchingRecipe(this.field_145850_b.func_199532_z(), this.field_145850_b, liquid, plan, (IInventory)this.craftingInventory);
        IFabricatorRecipe recipe = recipePair.orElse(null);
        if (!liquid.isEmpty() && recipe != null && !liquid.containsFluid(recipe.getLiquid())) {
            return Optional.empty();
        }
        return recipePair;
    }

    public ItemStack getResult(Optional<IFabricatorRecipe> myRecipePair) {
        IFabricatorRecipe myRecipe = myRecipePair.orElse(null);
        if (myRecipe == null) {
            return ItemStack.field_190927_a;
        }
        return myRecipe.getCraftingGridRecipe().func_77571_b().func_77946_l();
    }

    @Override
    public void onTake(int slotIndex, PlayerEntity player) {
        if (slotIndex == 2) {
            this.func_70298_a(2, 1);
        }
    }

    private void craftResult() {
        Optional<IFabricatorRecipe> myRecipePair = this.getRecipe();
        ItemStack craftResult = this.getResult(myRecipePair);
        IFabricatorRecipe myRecipe = myRecipePair.orElse(null);
        if (myRecipe != null && !craftResult.func_190926_b() && this.func_70301_a(2).func_190926_b()) {
            FluidStack drained;
            FluidStack liquid = myRecipe.getLiquid();
            if (this.removeFromInventory(myRecipe, false) && !(drained = this.moltenTank.drainInternal(liquid, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && drained.isFluidStackIdentical(liquid)) {
                Item planItem;
                this.removeFromInventory(myRecipe, true);
                this.moltenTank.drain(liquid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                if (!this.func_70301_a(1).func_190926_b() && (planItem = this.func_70301_a(1).func_77973_b()) instanceof ICraftingPlan) {
                    ItemStack planUsed = ((ICraftingPlan)planItem).planUsed(this.func_70301_a(1), craftResult);
                    this.func_70299_a(1, planUsed);
                }
                this.func_70299_a(2, craftResult);
            }
        }
    }

    private boolean removeFromInventory(IFabricatorRecipe recipe, boolean doRemove) {
        InventoryMapper inventory = new InventoryMapper((IInventory)this, 3, 18);
        return InventoryUtil.consumeIngredients(inventory, (NonNullList<Ingredient>)recipe.getCraftingGridRecipe().func_192400_c(), null, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        boolean hasRecipe = true;
        boolean hasLiquidResources = true;
        boolean hasResources = true;
        ItemStack plan = this.func_70301_a(1);
        Optional<IFabricatorRecipe> recipePair = RecipeManagers.fabricatorManager.findMatchingRecipe(this.field_145850_b.func_199532_z(), this.field_145850_b, this.moltenTank.getFluid(), plan, (IInventory)this.craftingInventory);
        if (recipePair.isPresent()) {
            IFabricatorRecipe recipe = recipePair.orElse(null);
            hasResources = this.removeFromInventory(recipe, false);
            FluidStack toDrain = recipe.getLiquid();
            FluidStack drained = this.moltenTank.drainInternal(toDrain, IFluidHandler.FluidAction.SIMULATE);
            hasLiquidResources = !drained.isEmpty() && drained.isFluidStackIdentical(toDrain);
        } else {
            IFabricatorSmeltingRecipe smelting = RecipeManagers.fabricatorSmeltingManager.findMatchingSmelting(this.field_145850_b.func_199532_z(), this.func_70301_a(0));
            hasRecipe = smelting != null;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasLiquidResources, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasResources, EnumErrorCode.NO_RESOURCE_INVENTORY);
        return hasRecipe;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    private int getMeltingPoint() {
        if (!this.func_70301_a(0).func_190926_b()) {
            IFabricatorSmeltingRecipe smelt = RecipeManagers.fabricatorSmeltingManager.findMatchingSmelting(this.func_145831_w().func_199532_z(), this.func_70301_a(0));
            if (smelt != null) {
                return smelt.getMeltingPoint();
            }
        } else if (this.moltenTank.getFluidAmount() > 0) {
            return this.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    public void getGUINetworkData(int i, int j) {
        if (i == 0) {
            this.heat = j;
        } else if (i == 1) {
            this.meltingPoint = j;
        }
    }

    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        iCrafting.func_71112_a(container, 0, this.heat);
        iCrafting.func_71112_a(container, 1, this.getMeltingPoint());
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerFabricator(windowId, player.field_71071_by, this);
    }
}

