/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.ContainerFiller;
import forestry.core.fluids.DrainOnlyFluidHandlerWrapper;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileBase;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerRaintank;
import forestry.factory.inventory.InventoryRaintank;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileRaintank
extends TileBase
implements ISidedInventory,
ILiquidTankTile {
    private static final FluidStack STACK_WATER = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
    private static final FluidStack WATER_PER_UPDATE = new FluidStack((Fluid)Fluids.field_204546_a, 10);
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final ContainerFiller containerFiller;
    @Nullable
    private Boolean canDumpBelow = null;
    private boolean dumpingFluid = false;
    private int fillingProgress;

    public TileRaintank() {
        super(FactoryTiles.RAIN_TANK.tileType());
        this.setInternalInventory(new InventoryRaintank(this));
        this.resourceTank = new FilteredTank(30000).setFilters(new Fluid[]{Fluids.field_204546_a});
        this.tankManager = new TankManager(this, this.resourceTank);
        this.containerFiller = new ContainerFiller(this.resourceTank, 12, (IInventory)this, 0, 1);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.tankManager.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.tankManager.read(compoundNBT);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        if (this.updateOnInterval(20)) {
            IErrorLogic errorLogic = this.getErrorLogic();
            BlockPos pos = this.func_174877_v();
            Biome biome = this.field_145850_b.func_226691_t_(pos);
            errorLogic.setCondition(biome.func_201851_b() != Biome.RainType.RAIN, EnumErrorCode.NO_RAIN_BIOME);
            BlockPos posAbove = pos.func_177984_a();
            boolean hasSky = this.field_145850_b.func_175710_j(posAbove);
            errorLogic.setCondition(!hasSky, EnumErrorCode.NO_SKY_RAIN_TANK);
            errorLogic.setCondition(!this.field_145850_b.func_175727_C(posAbove), EnumErrorCode.NOT_RAINING);
            if (!errorLogic.hasErrors()) {
                this.resourceTank.fillInternal(WATER_PER_UPDATE, IFluidHandler.FluidAction.EXECUTE);
            }
            this.containerFiller.updateServerSide();
        }
        if (this.canDumpBelow == null) {
            this.canDumpBelow = FluidHelper.canAcceptFluid(this.field_145850_b, this.func_174877_v().func_177977_b(), Direction.UP, STACK_WATER);
        }
        if (this.canDumpBelow.booleanValue() && (this.dumpingFluid || this.updateOnInterval(20))) {
            this.dumpingFluid = this.dumpFluidBelow();
        }
    }

    private boolean dumpFluidBelow() {
        LazyOptional fluidCap;
        if (!this.resourceTank.isEmpty() && (fluidCap = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP)).isPresent()) {
            return !FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)fluidCap.orElse(null)), (IFluidHandler)this.tankManager, (int)50, (boolean)true).isEmpty();
        }
        return false;
    }

    public boolean isFilling() {
        return this.fillingProgress > 0;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingProgress * i / 12;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingProgress = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        iCrafting.func_71112_a(container, 0, this.containerFiller.getFillingProgress());
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void onNeighborTileChange(World world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborTileChange(world, pos, neighbor);
        if (neighbor.equals((Object)pos.func_177977_b())) {
            this.canDumpBelow = FluidHelper.canAcceptFluid(world, neighbor, Direction.UP, STACK_WATER);
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> {
                if (facing == Direction.DOWN) {
                    return new DrainOnlyFluidHandlerWrapper(this.tankManager);
                }
                return this.tankManager;
            }).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerRaintank(windowId, inv, this);
    }
}

