/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISpeedUpgradable;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerSqueezer;
import forestry.factory.inventory.InventorySqueezer;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileSqueezer
extends TilePowered
implements ISocketable,
ISidedInventory,
ILiquidTankTile,
ISpeedUpgradable {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 2000;
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final TankManager tankManager;
    private final StandardTank productTank;
    private final InventorySqueezer inventory = new InventorySqueezer(this);
    @Nullable
    private ISqueezerRecipe currentRecipe;

    public TileSqueezer() {
        super(FactoryTiles.SQUEEZER.tileType(), 1100, 5000);
        this.setInternalInventory(this.inventory);
        this.productTank = new StandardTank(10000, false, true);
        this.tankManager = new TankManager(this, this.productTank);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.tankManager.write(compoundNBT);
        this.sockets.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        ICircuitBoard chipset;
        super.func_230337_a_(state, compoundNBT);
        this.tankManager.read(compoundNBT);
        this.sockets.read(compoundNBT);
        ItemStack chip = this.sockets.func_70301_a(0);
        if (!chip.func_190926_b() && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        this.sockets.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.sockets.readData(data);
    }

    @Override
    public void updateServerSide() {
        FluidStack fluid;
        super.updateServerSide();
        if (this.updateOnInterval(20) && !(fluid = this.productTank.getFluid()).isEmpty()) {
            this.inventory.fillContainers(fluid, this.tankManager);
        }
    }

    @Override
    public boolean workCycle() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (!this.inventory.removeResources(this.currentRecipe.getResources())) {
            return false;
        }
        FluidStack resultFluid = this.currentRecipe.getFluidOutput();
        this.productTank.fillInternal(resultFluid, IFluidHandler.FluidAction.EXECUTE);
        if (!this.currentRecipe.getRemnants().func_190926_b() && this.field_145850_b.field_73012_v.nextFloat() < this.currentRecipe.getRemnantsChance()) {
            ItemStack remnant = this.currentRecipe.getRemnants().func_77946_l();
            this.inventory.addRemnant(remnant, true);
        }
        return true;
    }

    private boolean checkRecipe() {
        ISqueezerRecipe matchingRecipe = null;
        if (this.inventory.hasResources()) {
            NonNullList<ItemStack> resources = this.inventory.getResources();
            boolean containsSets = false;
            if (this.currentRecipe != null) {
                InventoryMapper inventory = new InventoryMapper((IInventory)this, 0, 9);
                containsSets = InventoryUtil.consumeIngredients(inventory, this.currentRecipe.getResources(), null, false, false, false);
            }
            if ((matchingRecipe = this.currentRecipe != null && containsSets ? this.currentRecipe : RecipeManagers.squeezerManager.findMatchingRecipe(this.func_145831_w().func_199532_z(), resources)) == null) {
                for (ItemStack resource : resources) {
                    if (matchingRecipe != null) continue;
                    matchingRecipe = RecipeManagers.squeezerContainerManager.findMatchingContainerRecipe(this.func_145831_w().func_199532_z(), resource);
                }
            }
        }
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getProcessingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 200);
            }
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NO_RECIPE);
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasResources = this.inventory.hasResources();
        boolean hasRecipe = true;
        boolean canFill = true;
        boolean canAdd = true;
        if (hasResources) {
            boolean bl = hasRecipe = this.currentRecipe != null;
            if (hasRecipe) {
                FluidStack resultFluid = this.currentRecipe.getFluidOutput();
                boolean bl2 = canFill = this.productTank.fillInternal(resultFluid, IFluidHandler.FluidAction.SIMULATE) == resultFluid.getAmount();
                if (!this.currentRecipe.getRemnants().func_190926_b()) {
                    canAdd = this.inventory.addRemnant(this.currentRecipe.getRemnants(), false);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasResources, EnumErrorCode.NO_RESOURCE);
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!canFill, EnumErrorCode.NO_SPACE_TANK);
        errorLogic.setCondition(!canAdd, EnumErrorCode.NO_SPACE_INVENTORY);
        return hasResources && hasRecipe && canFill && canAdd;
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        if (stack.func_190926_b() || ChipsetManager.circuitRegistry.isChipset(stack)) {
            ICircuitBoard chipset;
            if (!this.sockets.func_70301_a(slot).func_190926_b() && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(this.sockets.func_70301_a(slot))) != null) {
                chipset.onRemoval(this);
            }
            this.sockets.func_70299_a(slot, stack);
            if (!stack.func_190926_b() && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(stack)) != null) {
                chipset.onInsertion(this);
            }
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.MACHINE;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerSqueezer(windowId, inv, this);
    }
}

